/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.support;

import java.util.Map;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class MockArchiveManifest {
    private static Filter<ArchivePath> EAR_MODULE_FILTER = new Filter<ArchivePath>(){

        public boolean include(ArchivePath pathObject) {
            String path = pathObject.get();
            return path.length() > 1 && !path.startsWith("/lib");
        }
    };

    public static void addCDIManifest(JavaArchive archive) {
        archive.addManifestResource((Asset)new ByteArrayAsset("<web-beans></web-beans>".getBytes()), ArchivePaths.create((String)"beans.xml"));
    }

    public static void addCDIManifest(WebArchive archive) {
        archive.add((Asset)new ByteArrayAsset("<beans/>".getBytes()), ArchivePaths.create((String)"WEB-INF/beans.xml"));
    }

    public static void addManifest(JavaArchive archive) {
        archive.addManifestResource((Asset)new ByteArrayAsset("<ejb-jar/>".getBytes()), ArchivePaths.create((String)"ejb-jar.xml"));
    }

    public static void addManifest(JavaArchive archive, boolean isCDI) {
        MockArchiveManifest.addManifest(archive);
        if (isCDI) {
            MockArchiveManifest.addCDIManifest(archive);
        }
    }

    public static void addManifest(WebArchive archive) {
        archive.add((Asset)new ByteArrayAsset("<web/>".getBytes()), ArchivePaths.create((String)"WEB-INF/web.xml"));
    }

    public static void addManifest(WebArchive archive, boolean isCDI) {
        MockArchiveManifest.addManifest(archive);
        if (isCDI) {
            MockArchiveManifest.addCDIManifest(archive);
        }
    }

    public static void addManifest(EnterpriseArchive archive) {
        Map modules = archive.getContent(EAR_MODULE_FILTER);
        StringBuffer appProperties = new StringBuffer();
        for (ArchivePath archivePath : modules.keySet()) {
            String path = archivePath.get().substring(1);
            appProperties.append(path.replace('.', '_')).append("-module=").append(path);
            appProperties.append('\n');
        }
        archive.addManifestResource((Asset)new ByteArrayAsset(appProperties.toString().getBytes()), "application.properties");
    }
}

