/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.deployers.support.MockArchiveManifest;
import org.jboss.test.deployers.support.crm.CrmWebBean;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.support.ui.UIWebBean;
import org.jboss.test.deployers.support.web.ServletWebBean;
import org.jboss.test.deployers.test.AbstractWeldTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnvironmentTest<E>
extends AbstractWeldTest {
    protected static final String EAR_NAME = "simple.ear";
    protected static final String EJB_JAR_NAME = "ejb.jar";
    protected static final String WAR_NAME = "simple.war";

    public AbstractEnvironmentTest(String name) {
        super(name);
    }

    private static void addExpectedClass(Set<String> expected, Class<?> clazz) {
        expected.add(clazz.getName());
    }

    private void assertExpectedClasses(E environment, Set<String> expected) {
        Collection<String> weldClasses = this.getClasses(environment);
        AbstractEnvironmentTest.assertNotNull(weldClasses);
        AbstractEnvironmentTest.assertTrue((String)"Unexpected empty weld classes collection", (expected.isEmpty() || !weldClasses.isEmpty() ? 1 : 0) != 0);
        for (String className : weldClasses) {
            AbstractEnvironmentTest.assertTrue((String)("Found unexpected class: " + className), (boolean)expected.remove(className));
        }
        this.assertEmpty("Should be emtpy, missing " + expected, expected);
    }

    protected void assertExpectedClasses(E environment, Class<?> ... classes) {
        HashSet<String> expected = new HashSet<String>();
        for (Class<?> clazz : classes) {
            AbstractEnvironmentTest.addExpectedClass(expected, clazz);
        }
        this.assertExpectedClasses(environment, expected);
    }

    protected JavaArchive createEjbJar(boolean jarCDI) {
        return this.createEjbJar(EJB_JAR_NAME, jarCDI, PlainJavaBean.class);
    }

    protected JavaArchive createEjbJar(String jarName, boolean jarCDI, Class<?> ... classes) {
        JavaArchive ejbJar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)jarName);
        for (Class<?> clazz : classes) {
            ejbJar.addClass(clazz);
        }
        MockArchiveManifest.addManifest(ejbJar, jarCDI);
        return ejbJar;
    }

    protected WebArchive createWar(boolean warCDI) {
        return this.createWar(WAR_NAME, warCDI, ServletWebBean.class);
    }

    protected WebArchive createWar(String warName, boolean warCDI, Class<?> ... classes) {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)warName);
        for (Class<?> clazz : classes) {
            war.addClass(clazz);
        }
        MockArchiveManifest.addManifest(war, warCDI);
        return war;
    }

    protected WebArchive createWarWithLib(boolean warCDI, boolean libCDI) {
        WebArchive war = this.createWar(warCDI);
        this.createLib((LibraryContainer<?>)war, "lib.jar", libCDI, UIWebBean.class);
        return war;
    }

    protected WebArchive createWarWithLibs(boolean warCDI, boolean lib1CDI, boolean lib2CDI) {
        WebArchive war = this.createWar(warCDI);
        this.createLib((LibraryContainer<?>)war, "lib1.jar", lib1CDI, UIWebBean.class);
        this.createLib((LibraryContainer<?>)war, "lib2.jar", lib2CDI, CrmWebBean.class);
        return war;
    }

    protected void createLib(LibraryContainer<?> archive, String libName, boolean cdi, Class<?> ... classes) {
        JavaArchive lib = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)libName);
        if (cdi) {
            MockArchiveManifest.addCDIManifest(lib);
        }
        for (Class<?> libClass : classes) {
            lib.addClass(libClass);
        }
        archive.addLibrary((Archive)lib);
    }

    protected abstract Collection<String> getClasses(E var1);
}

