/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.classloader.plugins.jdk.AbstractJDKChecker;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.deployer.kernel.BeanMetaDataFactoryVisitor;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.vfs3.ArchiveFileSystem;
import org.jboss.test.deployers.BootstrapDeployersTest;
import org.jboss.test.deployers.support.crm.CrmWebBean;
import org.jboss.test.deployers.support.ejb.MySLSBean;
import org.jboss.test.deployers.support.ext.ExternalWebBean;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.support.jsf.NotWBJsfBean;
import org.jboss.test.deployers.support.ui.UIWebBean;
import org.jboss.test.deployers.support.util.SomeUtil;
import org.jboss.test.deployers.support.web.ServletWebBean;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWeldTest
extends BootstrapDeployersTest {
    private static TempFileProvider tempFileProvider;
    private final List<Closeable> vfsHandles = new ArrayList<Closeable>();
    private Collection<VFSDeploymentUnit> units = new ArrayList<VFSDeploymentUnit>();

    protected AbstractWeldTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        Set excluded = AbstractJDKChecker.getExcluded();
        excluded.add(BeanMetaDataFactoryVisitor.class);
        tempFileProvider = TempFileProvider.create((String)"shrinkwrap-", (ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor());
        super.setUp();
    }

    protected void assertInstanceOf(Object target, String className, ClassLoader cl) throws Exception {
        Class<?> clazz = cl.loadClass(className);
        AbstractWeldTest.assertTrue((boolean)clazz.isInstance(target));
    }

    protected boolean invoke(Object target, String name) throws Exception {
        Method m = target.getClass().getMethod("is" + name, new Class[0]);
        return (Boolean)m.invoke(target, new Object[0]);
    }

    protected VirtualFile createBasicEar() throws Exception {
        return this.createBasicEar(SomeUtil.class);
    }

    protected VirtualFile createBasicEar(Class<?> utilClass) throws Exception {
        VirtualFile ear = this.createTopLevelWithUtil(utilClass);
        VirtualFile jar = ear.getChild("simple.jar");
        this.createAssembledDirectory(jar).addPackage(PlainJavaBean.class).addPath("/weld/simple/jar");
        VirtualFile ejbs = ear.getChild("ejbs.jar");
        this.createAssembledDirectory(ejbs).addPackage(MySLSBean.class).addPath("/weld/simple/ejb");
        VirtualFile war = ear.getChild("simple.war");
        this.createAssembledDirectory(war).addPackage("WEB-INF/classes", ServletWebBean.class).addPath("/weld/simple/web").addPackage("WEB-INF/lib/ui.jar", UIWebBean.class).addPath("WEB-INF/lib/ui.jar", "/weld/simple/ui");
        war = ear.getChild("crm.war");
        this.createAssembledDirectory(war).addPackage("WEB-INF/classes", NotWBJsfBean.class).addPackage("WEB-INF/lib/crm.jar", CrmWebBean.class).addPath("WEB-INF/lib/crm.jar", "/weld/simple/crm");
        this.enableTrace("org.jboss.deployers");
        return ear;
    }

    protected VirtualFile createTopLevelWithUtil() throws Exception {
        return this.createTopLevelWithUtil("/weld/simple");
    }

    protected VirtualFile createTopLevelWithUtil(Class<?> utilClass) throws Exception {
        if (utilClass != null) {
            return this.createTopLevelWithUtil("/weld/simple", utilClass);
        }
        return this.createTopLevelWithUtil();
    }

    protected VirtualFile createTopLevelWithUtil(String path) throws Exception {
        return this.createTopLevelWithUtil(path, SomeUtil.class);
    }

    protected VirtualFile createTopLevelWithUtil(String path, Class<?> utilClass) throws Exception {
        VirtualFile earFile = VFS.getChild((String)"top-level.ear");
        this.createAssembledDirectory(earFile).addPath(path).addPackage("lib/util.jar", utilClass).addPackage("lib/ext.jar", ExternalWebBean.class).addPath("lib/ext.jar", "/weld/simple/ext");
        return earFile;
    }

    protected VirtualFile createWarInEar() throws Exception {
        VirtualFile earFile = VFS.getChild((String)"war-in-ear.ear");
        this.createAssembledDirectory(earFile).addPath("/weld/warinear").addPackage("simple.war/WEB-INF/classes", ServletWebBean.class).addPath("simple.war", "/weld/simple/web");
        return earFile;
    }

    protected VirtualFile createJarInEar() throws Exception {
        VirtualFile earFile = VFS.getChild((String)"jar-in-ear.ear");
        this.createAssembledDirectory(earFile).addPath("/weld/jarinear").addPackage("simple.jar", PlainJavaBean.class).addPath("simple.jar", "/weld/simple/jar");
        return earFile;
    }

    protected VirtualFile createWar(String warName, Class<?> reference) throws Exception {
        VirtualFile warFile = VFS.getChild((String)warName);
        this.createAssembledDirectory(warFile).addPackage("WEB-INF/classes", reference).addPath("/weld/simple/web");
        return warFile;
    }

    protected VirtualFile createEjbJar(String jarName, Class<?> reference) throws Exception {
        VirtualFile jarFile = VFS.getChild((String)jarName);
        this.createAssembledDirectory(jarFile).addPackage(reference).addPath("/weld/simple/ejb");
        return jarFile;
    }

    protected VFSDeploymentUnit assertDeploy(Archive<?> archive) throws Exception {
        VirtualFile virtualFile = this.mount(archive);
        VFSDeploymentUnit unit = this.assertDeploy(virtualFile);
        return unit;
    }

    protected VFSDeploymentUnit assertDeploy(VirtualFile virtualFile) throws Exception {
        VFSDeploymentUnit unit = super.assertDeploy(virtualFile);
        this.units.add(unit);
        return unit;
    }

    private VirtualFile mount(Archive<?> archive) throws IOException {
        TempDir tempDir = tempFileProvider.createTempDir(archive.getName());
        VirtualFile virtualFile = VFS.getChild((String)UUID.randomUUID().toString()).getChild(archive.getName());
        this.vfsHandles.add(VFS.mount((VirtualFile)virtualFile, (FileSystem)new ArchiveFileSystem(archive, tempDir)));
        this.mountZipFiles(virtualFile);
        return virtualFile;
    }

    private void mountZipFiles(VirtualFile file) throws IOException {
        if (!file.isDirectory() && file.getName().matches("^.*\\.([EeWwJj][Aa][Rr]|[Zz][Ii][Pp])$")) {
            this.vfsHandles.add(VFS.mountZip((VirtualFile)file, (VirtualFile)file, (TempFileProvider)tempFileProvider));
        }
        if (file.isDirectory()) {
            for (VirtualFile child : file.getChildren()) {
                this.mountZipFiles(child);
            }
        }
    }

    protected void tearDown() throws Exception {
        for (VFSDeploymentUnit unit : this.units) {
            this.undeploy((DeploymentUnit)unit);
        }
        this.units.clear();
        for (Closeable vfsHandle : this.vfsHandles) {
            vfsHandle.close();
        }
        this.vfsHandles.clear();
        super.tearDown();
    }
}

