/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.test.deployers.support.crm.CrmWebBean;
import org.jboss.test.deployers.support.ejb.BusinessInterface;
import org.jboss.test.deployers.support.ejb.MySLSBean;
import org.jboss.test.deployers.support.ext.ExternalWebBean;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.support.jsf.NotWBJsfBean;
import org.jboss.test.deployers.support.ui.UIWebBean;
import org.jboss.test.deployers.support.util.SomeUtil;
import org.jboss.test.deployers.support.web.ServletWebBean;
import org.jboss.test.deployers.test.AbstractSingleArchiveTest;
import org.jboss.util.UnreachableStatementException;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveEnvironmentTestCase
extends AbstractSingleArchiveTest<WeldDiscoveryEnvironment> {
    public ArchiveEnvironmentTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ArchiveEnvironmentTestCase.suite(ArchiveEnvironmentTestCase.class);
    }

    @Override
    public void testEjbJarInEar() throws Exception {
        super.testEjbJarInEar();
        this.assertSingleChildAsUnit("ejb.jar");
        this.assertNoArchiveInfo(this.unit);
    }

    @Override
    public void testEjbJarWithoutXmlInEar() throws Exception {
        super.testEjbJarWithoutXmlInEar();
        this.assertSingleChildAsUnit("ejb.jar");
        this.assertNoArchiveInfo(this.unit);
    }

    @Override
    protected void assertWarsInEar() {
        WeldDiscoveryEnvironment discovery = this.assertDiscoveryEnvironment();
        this.assertExpectedClasses(discovery, new Class[0]);
        this.assertExpectedResources(discovery, new String[0]);
        Iterator i$ = this.unit.getChildren().iterator();
        while (i$.hasNext()) {
            DeploymentUnit childUnit;
            this.unit = childUnit = (DeploymentUnit)i$.next();
            if (this.unit.getSimpleName().equals("simple1.war")) {
                discovery = this.assertDiscoveryEnvironment();
                this.assertExpectedClasses(discovery, ServletWebBean.class);
                this.assertExpectedWarResources(discovery, "warinear.ear/simple1.war", true, new String[0]);
                continue;
            }
            if (this.unit.getSimpleName().equals("simple2.war")) {
                discovery = this.assertDiscoveryEnvironment();
                this.assertExpectedClasses(discovery, NotWBJsfBean.class);
                this.assertExpectedWarResources(discovery, "warinear.ear/simple2.war", true, new String[0]);
                continue;
            }
            ArchiveEnvironmentTestCase.fail((String)("Unexpected childUnit: " + this.unit.getSimpleName()));
        }
    }

    @Override
    protected void assertBasicEar() {
        WeldDiscoveryEnvironment discovery = this.assertDiscoveryEnvironment();
        this.assertExpectedClasses(discovery, BusinessInterface.class, MySLSBean.class, ExternalWebBean.class, PlainJavaBean.class);
        this.assertExpectedResources(discovery, "top-level.ear/ejbs.jar", "top-level.ear/lib/ext.jar", "top-level.ear/simple.jar");
        Iterator i$ = this.unit.getChildren().iterator();
        while (i$.hasNext()) {
            DeploymentUnit childUnit;
            this.unit = childUnit = (DeploymentUnit)i$.next();
            if (childUnit.getName().endsWith("simple.war/")) {
                discovery = this.assertDiscoveryEnvironment();
                this.assertExpectedClasses(discovery, UIWebBean.class, ServletWebBean.class);
                this.assertExpectedWarResources(discovery, "top-level.ear/simple.war", true, "ui.jar");
                continue;
            }
            if (childUnit.getName().endsWith("crm.war/")) {
                discovery = this.assertDiscoveryEnvironment();
                this.assertExpectedClasses(discovery, CrmWebBean.class);
                this.assertExpectedWarResources(discovery, "top-level.ear/crm.war", false, "crm.jar");
                continue;
            }
            ArchiveInfo archiveInfo = (ArchiveInfo)childUnit.getAttachment(ArchiveInfo.class);
            ArchiveEnvironmentTestCase.assertNull((String)("Unit " + this.unit.getName() + " contains a not null ArchiveInfo"), (Object)archiveInfo);
        }
    }

    @Override
    protected void assertBasicEarFullCDI() {
        WeldDiscoveryEnvironment discovery = this.assertDiscoveryEnvironment();
        this.assertExpectedClasses(discovery, BusinessInterface.class, MySLSBean.class, ExternalWebBean.class, PlainJavaBean.class, SomeUtil.class);
        this.assertExpectedResources(discovery, "top-level.ear/lib/util.jar", "top-level.ear/lib/ext.jar", "top-level.ear/simple.jar", "top-level.ear/ejbs.jar");
        Iterator i$ = this.unit.getChildren().iterator();
        while (i$.hasNext()) {
            DeploymentUnit childUnit;
            this.unit = childUnit = (DeploymentUnit)i$.next();
            if (childUnit.getName().endsWith("simple.war/")) {
                discovery = this.assertDiscoveryEnvironment();
                this.assertExpectedClasses(discovery, UIWebBean.class, ServletWebBean.class);
                this.assertExpectedWarResources(discovery, "top-level.ear/simple.war", true, "ui.jar");
                continue;
            }
            if (childUnit.getName().endsWith("crm.war/")) {
                discovery = this.assertDiscoveryEnvironment();
                this.assertExpectedClasses(discovery, CrmWebBean.class, NotWBJsfBean.class);
                this.assertExpectedWarResources(discovery, "top-level.ear/crm.war", true, "crm.jar");
                continue;
            }
            ArchiveInfo archiveInfo = (ArchiveInfo)childUnit.getAttachment(ArchiveInfo.class);
            ArchiveEnvironmentTestCase.assertNull((String)("Unit " + this.unit.getName() + " contains a not null ArchiveInfo"), (Object)archiveInfo);
        }
    }

    @Override
    protected void assertBasicEarWithoutXml() {
        WeldDiscoveryEnvironment discovery = this.assertDiscoveryEnvironment();
        this.assertExpectedClasses(discovery, new Class[0]);
        this.assertExpectedResources(discovery, new String[0]);
        for (DeploymentUnit childUnit : this.unit.getChildren()) {
            if (childUnit.getName().endsWith("simple.war/") || childUnit.getName().endsWith("crm.war/")) {
                this.unit = childUnit;
                discovery = this.assertDiscoveryEnvironment();
                this.assertExpectedClasses(discovery, new Class[0]);
                this.assertExpectedResources(discovery, new String[0]);
                continue;
            }
            ArchiveInfo archiveInfo = (ArchiveInfo)childUnit.getAttachment(ArchiveInfo.class);
            ArchiveEnvironmentTestCase.assertNull((String)("Unit " + this.unit.getName() + " contains a not null ArchiveInfo"), (Object)archiveInfo);
        }
    }

    @Override
    protected void assertEmptyEnvironment() {
        WeldDiscoveryEnvironment discovery = this.assertDiscoveryEnvironment();
        this.assertExpectedClasses(discovery, new Class[0]);
        this.assertExpectedResources(discovery, new String[0]);
    }

    @Override
    protected WeldDiscoveryEnvironment assertSingleEnvironment(String name) {
        if (this.unit.getName().contains(name)) {
            return this.assertDiscoveryEnvironment(name);
        }
        for (DeploymentUnit childUnit : this.unit.getChildren()) {
            if (!childUnit.getName().contains(name)) continue;
            return this.assertDiscoveryEnvironment(childUnit, name);
        }
        ArchiveEnvironmentTestCase.fail((String)("Was not able to find a unit with suffix " + name));
        throw new UnreachableStatementException();
    }

    @Override
    protected Collection<String> getClasses(WeldDiscoveryEnvironment environment) {
        return environment.getWeldClasses();
    }

    @Override
    protected Collection<URL> getResources(WeldDiscoveryEnvironment environment) {
        return environment.getWeldXml();
    }

    private void assertSingleChildAsUnit(String name) {
        ArchiveEnvironmentTestCase.assertEquals((int)1, (int)this.unit.getChildren().size());
        this.unit = (DeploymentUnit)this.unit.getChildren().iterator().next();
        ArchiveEnvironmentTestCase.assertEquals((String)this.unit.getSimpleName(), (String)name);
    }

    private void assertNoArchiveInfo(DeploymentUnit unit) {
        ArchiveEnvironmentTestCase.assertNull((Object)unit.getAttachment(ArchiveInfo.class));
    }

    private WeldDiscoveryEnvironment assertDiscoveryEnvironment(String name) {
        return this.assertDiscoveryEnvironment(this.unit, name);
    }

    private WeldDiscoveryEnvironment assertDiscoveryEnvironment(DeploymentUnit unit, String name) {
        ArchiveInfo archiveInfo = (ArchiveInfo)unit.getAttachment(ArchiveInfo.class);
        ArchiveEnvironmentTestCase.assertNotNull((Object)archiveInfo);
        ArchiveEnvironmentTestCase.assertTrue((String)("Unit name \"" + unit.getName() + "\" expected to end with \"" + name + "\" suffix"), (boolean)unit.getName().endsWith(name + '/'));
        WeldDiscoveryEnvironment discovery = archiveInfo.getEnvironment();
        ArchiveEnvironmentTestCase.assertNotNull((Object)discovery);
        return discovery;
    }

    private WeldDiscoveryEnvironment assertDiscoveryEnvironment() {
        ArchiveInfo archiveInfo = (ArchiveInfo)this.unit.getAttachment(ArchiveInfo.class);
        ArchiveEnvironmentTestCase.assertNotNull((Object)archiveInfo);
        WeldDiscoveryEnvironment discovery = archiveInfo.getEnvironment();
        ArchiveEnvironmentTestCase.assertNotNull((Object)discovery);
        return discovery;
    }
}

