/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import junit.framework.Test;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.support.web.ServletWebBean;
import org.jboss.test.deployers.test.AbstractWeldTest;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;
import org.jboss.weld.integration.deployer.env.bda.Classpath;

public class ArchiveInfoDeploymentTestCase
extends AbstractWeldTest {
    private static String DEFAULT_CLASSPATH_NAME = ClassLoaderSystem.getInstance().getDefaultDomain().getName();
    private Classpath defaultClasspath;
    private VFSDeploymentUnit unit;

    public ArchiveInfoDeploymentTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ArchiveInfoDeploymentTestCase.suite(ArchiveInfoDeploymentTestCase.class);
    }

    public void tearDown() throws Exception {
        this.undeploy((DeploymentUnit)this.unit);
        super.tearDown();
    }

    public void testEjbJar() throws Exception {
        VirtualFile ejbJar = this.createEjbJar("simple.jar", PlainJavaBean.class);
        this.unit = this.assertDeploy(ejbJar);
        this.assertArchiveInfoWithDefaultClasspath(this.unit);
        this.assertEmpty(this.unit.getChildren());
    }

    public void testWar() throws Exception {
        VirtualFile war = this.createWar("simple.war", ServletWebBean.class);
        this.unit = this.assertDeploy(war);
        this.assertArchiveInfoWithWarClasspath((DeploymentUnit)this.unit);
    }

    public void testEjbJarinEar() throws Exception {
        VirtualFile ejbJar = this.createJarInEar();
        this.unit = this.assertDeploy(ejbJar);
        this.assertArchiveInfoWithDefaultClasspath(this.unit);
        for (DeploymentUnit childUnit : this.unit.getChildren()) {
            ArchiveInfoDeploymentTestCase.assertNull((Object)childUnit.getAttachment(ArchiveInfo.class));
        }
    }

    public void testWarinEar() throws Exception {
        VirtualFile warInEar = this.createWarInEar();
        this.unit = this.assertDeploy(warInEar);
        this.assertArchiveInfoWithDefaultClasspath(this.unit);
        for (DeploymentUnit childUnit : this.unit.getChildren()) {
            this.assertArchiveInfoWithWarClasspath(childUnit);
        }
    }

    public void testEarWithUtil() throws Exception {
        VirtualFile ear = this.createTopLevelWithUtil("/weld/earwithutil");
        this.unit = this.assertDeploy(ear);
        this.assertArchiveInfoWithDefaultClasspath(this.unit);
        for (DeploymentUnit childUnit : this.unit.getChildren()) {
            ArchiveInfoDeploymentTestCase.assertNull((Object)childUnit.getAttachment(ArchiveInfo.class));
        }
    }

    public void testJarWarInEar() throws Exception {
        VirtualFile ear = VFS.getChild((String)"jar-in-ear.ear");
        this.createAssembledDirectory(ear).addPath("/weld/jarwarinear").addPackage("simple.jar", PlainJavaBean.class).addPackage("simple.war/WEB-INF/classes", PlainJavaBean.class).addPath("simple.war", "/weld/warwowb/web");
        this.unit = this.assertDeploy(ear);
        this.assertArchiveInfoWithDefaultClasspath(this.unit);
        for (DeploymentUnit childUnit : this.unit.getChildren()) {
            if (childUnit.getName().endsWith("simple.jar/")) {
                ArchiveInfoDeploymentTestCase.assertNull((Object)childUnit.getAttachment(ArchiveInfo.class));
                continue;
            }
            if (childUnit.getName().endsWith("simple.war/")) {
                this.assertArchiveInfoWithWarClasspath(childUnit);
                continue;
            }
            ArchiveInfoDeploymentTestCase.fail((String)("Unexpected unit name: " + childUnit.getName()));
        }
    }

    public void testEar() throws Exception {
        VirtualFile ear = this.createBasicEar();
        this.unit = this.assertDeploy(ear);
        this.assertArchiveInfoWithDefaultClasspath(this.unit);
        for (DeploymentUnit childUnit : this.unit.getChildren()) {
            ArchiveInfo archiveInfo = (ArchiveInfo)childUnit.getAttachment(ArchiveInfo.class);
            if (childUnit.getName().endsWith(".war/")) {
                ArchiveInfoDeploymentTestCase.assertNotNull((String)"Null ArchiveInfo", (Object)archiveInfo);
                this.assertNonDefaultClasspath(childUnit.getName(), archiveInfo.getClasspath());
                continue;
            }
            ArchiveInfoDeploymentTestCase.assertNull((String)("ArchiveInfo for unit " + childUnit.getName() + " is not null"), (Object)archiveInfo);
        }
    }

    private void assertArchiveInfoWithDefaultClasspath(VFSDeploymentUnit unit) {
        ArchiveInfo archiveInfo = (ArchiveInfo)unit.getAttachment(ArchiveInfo.class);
        ArchiveInfoDeploymentTestCase.assertNotNull((String)"Null ArchiveInfo", (Object)archiveInfo);
        this.assertDefaultClasspath(archiveInfo.getClasspath());
    }

    private void assertArchiveInfoWithWarClasspath(DeploymentUnit unit) {
        ArchiveInfo archiveInfo = (ArchiveInfo)unit.getAttachment(ArchiveInfo.class);
        ArchiveInfoDeploymentTestCase.assertNotNull((String)("Null ArchiveInfo for unit " + unit), (Object)archiveInfo);
        this.assertClasspath(unit.getName(), archiveInfo.getClasspath());
        this.assertEmpty(unit.getChildren());
    }

    private void assertDefaultClasspath(Classpath classpath) {
        this.assertClasspath(DEFAULT_CLASSPATH_NAME, classpath);
        this.defaultClasspath = classpath;
    }

    private void assertNonDefaultClasspath(String name, Classpath classpath) {
        this.assertClasspath(name, classpath);
        ArchiveInfoDeploymentTestCase.assertNotSame((Object)this.defaultClasspath, (Object)classpath);
    }

    private void assertClasspath(String name, Classpath classpath) {
        ArchiveInfoDeploymentTestCase.assertNotNull((Object)classpath);
        ArchiveInfoDeploymentTestCase.assertFalse((boolean)classpath.iterator().hasNext());
        ArchiveInfoDeploymentTestCase.assertEquals((String)name, (String)classpath.getName());
    }
}

