/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.deployers.support.CheckableBootstrap;
import org.jboss.test.deployers.support.MockArchiveManifest;
import org.jboss.test.deployers.support.MockEjbInjectionServices;
import org.jboss.test.deployers.support.MockEjbServices;
import org.jboss.test.deployers.support.MockEmptyEjbServices;
import org.jboss.test.deployers.support.MockTransactionServices;
import org.jboss.test.deployers.support.MockWeldBootstrap;
import org.jboss.test.deployers.support.WeldDEWrapper;
import org.jboss.test.deployers.support.crm.CrmWebBean;
import org.jboss.test.deployers.support.ejb.BusinessInterface;
import org.jboss.test.deployers.support.ejb.MySLSBean;
import org.jboss.test.deployers.support.ext.ExternalWebBean;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.support.jsf.NotWBJsfBean;
import org.jboss.test.deployers.support.ui.UIWebBean;
import org.jboss.test.deployers.support.util.SomeUtil;
import org.jboss.test.deployers.support.web.ServletWebBean;
import org.jboss.test.deployers.test.AbstractEnvironmentTest;
import org.jboss.test.deployers.vfs.classloader.support.a.A;
import org.jboss.test.deployers.vfs.classloader.support.b.B;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.bda.DeploymentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBeanDeploymentArchiveTestCase
extends AbstractEnvironmentTest<BeanDeploymentArchive> {
    private Bootstrap bootstrap = new MockWeldBootstrap();

    public LoadBeanDeploymentArchiveTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return LoadBeanDeploymentArchiveTestCase.suite(LoadBeanDeploymentArchiveTestCase.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        JavaArchive mockJar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"mock.jar");
        mockJar.addClass(CheckableBootstrap.class);
        mockJar.addClass(MockEjbServices.class);
        mockJar.addClass(MockEmptyEjbServices.class);
        mockJar.addClass(MockEjbInjectionServices.class);
        mockJar.addClass(MockTransactionServices.class);
        mockJar.addClass(MockWeldBootstrap.class);
        mockJar.addClass(WeldDEWrapper.class);
        this.assertDeploy((Archive<?>)mockJar);
    }

    public void testEjbJars() throws Exception {
        JavaArchive ejbJar1 = this.createEjbJar("ejb1.jar", true, PlainJavaBean.class);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ejbJar1);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)unit);
        Deployment deployment1 = this.initializeDeploymentBean((DeploymentUnit)unit);
        JavaArchive ejbJar2 = this.createEjbJar("ejb2.jar", true, MySLSBean.class, BusinessInterface.class);
        unit = this.assertDeploy((Archive<?>)ejbJar2);
        Class<?> mySLSBeanClass = this.getClass(MySLSBean.class, (DeploymentUnit)unit);
        Class<?> businessInterface = this.getClass(BusinessInterface.class, (DeploymentUnit)unit);
        Deployment deployment2 = this.initializeDeploymentBean((DeploymentUnit)unit);
        LoadBeanDeploymentArchiveTestCase.assertNotSame((Object)deployment1, (Object)deployment2);
        BeanDeploymentArchive bda1 = (BeanDeploymentArchive)deployment1.getBeanDeploymentArchives().iterator().next();
        BeanDeploymentArchive bda2 = (BeanDeploymentArchive)deployment2.getBeanDeploymentArchives().iterator().next();
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment1.loadBeanDeploymentArchive(plainJavaBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment1.loadBeanDeploymentArchive(plainJavaBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(mySLSBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(businessInterface));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(mySLSBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(businessInterface));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment2.loadBeanDeploymentArchive(plainJavaBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment2.loadBeanDeploymentArchive(plainJavaBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(mySLSBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(mySLSBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(businessInterface));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(businessInterface));
    }

    public void testMixedEjbJars() throws Exception {
        JavaArchive ejbJar1 = this.createEjbJar("ejb1.jar", true, PlainJavaBean.class);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ejbJar1);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)unit);
        Deployment deployment1 = this.initializeDeploymentBean((DeploymentUnit)unit);
        JavaArchive ejbJar2 = this.createEjbJar("ejb2.jar", false, MySLSBean.class, BusinessInterface.class);
        unit = this.assertDeploy((Archive<?>)ejbJar2);
        ClassLoader classLoader2 = unit.getClassLoader();
        Class<?> mySLSBeanClass = classLoader2.loadClass(MySLSBean.class.getName());
        Class<?> businessInterface = classLoader2.loadClass(BusinessInterface.class.getName());
        BeanDeploymentArchive bda1 = (BeanDeploymentArchive)deployment1.getBeanDeploymentArchives().iterator().next();
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment1.loadBeanDeploymentArchive(plainJavaBeanClass));
        BeanDeploymentArchive bda2 = deployment1.loadBeanDeploymentArchive(mySLSBeanClass);
        this.assertBDAId(bda2, "ejb2.jar");
        this.assertExpectedClasses(bda2, MySLSBean.class);
        this.assertNoBeansXml(bda2);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(mySLSBeanClass));
        this.assertBDAId(bda2, "ejb2.jar");
        this.assertExpectedClasses(bda2, MySLSBean.class);
        this.assertNoBeansXml(bda2);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(businessInterface));
        this.assertBDAId(bda2, "ejb2.jar");
        this.assertExpectedClasses(bda2, MySLSBean.class, BusinessInterface.class);
        this.assertNoBeansXml(bda2);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(businessInterface));
        this.assertBDAId(bda2, "ejb2.jar");
        this.assertExpectedClasses(bda2, MySLSBean.class, BusinessInterface.class);
        this.assertNoBeansXml(bda2);
    }

    public void testEjbJarsInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple.ear");
        JavaArchive ejbJar1 = this.createEjbJar("ejbJar1.jar", true, PlainJavaBean.class);
        ear.addModule((Archive)ejbJar1);
        JavaArchive ejbJar2 = this.createEjbJar("ejbJar2.jar", true, MySLSBean.class, BusinessInterface.class);
        ear.addModule((Archive)ejbJar2);
        MockArchiveManifest.addManifest(ear);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ear);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)unit);
        Class<?> mySLSBeanClass = this.getClass(MySLSBean.class, (DeploymentUnit)unit);
        Class<?> businessInterface = this.getClass(BusinessInterface.class, (DeploymentUnit)unit);
        Deployment deployment = this.initializeDeploymentBean();
        BeanDeploymentArchive bda = deployment.loadBeanDeploymentArchive(plainJavaBeanClass);
        this.assertBDAId(bda, "simple.ear");
        this.assertExpectedClasses(bda, PlainJavaBean.class, MySLSBean.class, BusinessInterface.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(mySLSBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(businessInterface));
    }

    public void testMixedEjbJarsInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple.ear");
        JavaArchive ejbJar1 = this.createEjbJar("ejbJar1.jar", true, PlainJavaBean.class);
        ear.addModule((Archive)ejbJar1);
        JavaArchive ejbJar2 = this.createEjbJar("ejbJar2.jar", false, MySLSBean.class, BusinessInterface.class);
        ear.addModule((Archive)ejbJar2);
        MockArchiveManifest.addManifest(ear);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ear);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)unit);
        Class<?> mySLSBeanClass = this.getClass(MySLSBean.class, (DeploymentUnit)unit);
        Class<?> businessInterface = this.getClass(BusinessInterface.class, (DeploymentUnit)unit);
        Deployment deployment = this.initializeDeploymentBean();
        BeanDeploymentArchive bda = deployment.loadBeanDeploymentArchive(plainJavaBeanClass);
        this.assertBDAId(bda, "simple.ear");
        this.assertExpectedClasses(bda, PlainJavaBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(mySLSBeanClass));
        this.assertBDAId(bda, "simple.ear");
        this.assertExpectedClasses(bda, PlainJavaBean.class, MySLSBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(mySLSBeanClass));
        this.assertBDAId(bda, "simple.ear");
        this.assertExpectedClasses(bda, PlainJavaBean.class, MySLSBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(businessInterface));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(mySLSBeanClass));
        this.assertBDAId(bda, "simple.ear");
        this.assertExpectedClasses(bda, PlainJavaBean.class, MySLSBean.class, BusinessInterface.class);
    }

    public void testEjbJarsInEars() throws Exception {
        EnterpriseArchive ear1 = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple1.ear");
        JavaArchive ejbJar1 = this.createEjbJar("ejbJar1.jar", true, PlainJavaBean.class);
        ear1.addModule((Archive)ejbJar1);
        MockArchiveManifest.addManifest(ear1);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ear1);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)unit);
        Deployment deployment1 = this.initializeDeploymentBean((DeploymentUnit)unit);
        EnterpriseArchive ear2 = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple2.ear");
        JavaArchive ejbJar2 = this.createEjbJar("ejbJar2.jar", true, MySLSBean.class, BusinessInterface.class);
        ear2.addModule((Archive)ejbJar2);
        MockArchiveManifest.addManifest(ear2);
        unit = this.assertDeploy((Archive<?>)ear2);
        Class<?> mySLSBeanClass = this.getClass(MySLSBean.class, (DeploymentUnit)unit);
        Class<?> businessInterface = this.getClass(BusinessInterface.class, (DeploymentUnit)unit);
        Deployment deployment2 = this.initializeDeploymentBean((DeploymentUnit)unit);
        BeanDeploymentArchive bda1 = (BeanDeploymentArchive)deployment1.getBeanDeploymentArchives().iterator().next();
        BeanDeploymentArchive bda2 = (BeanDeploymentArchive)deployment2.getBeanDeploymentArchives().iterator().next();
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment1.loadBeanDeploymentArchive(plainJavaBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment1.loadBeanDeploymentArchive(plainJavaBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(mySLSBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(businessInterface));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(mySLSBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment1.loadBeanDeploymentArchive(businessInterface));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment2.loadBeanDeploymentArchive(plainJavaBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment2.loadBeanDeploymentArchive(plainJavaBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(mySLSBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(mySLSBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(businessInterface));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(businessInterface));
    }

    public void testMixedEjbJarsInEars() throws Exception {
        EnterpriseArchive ear1 = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple1.ear");
        JavaArchive ejbJar1 = this.createEjbJar("ejbJar1.jar", false, PlainJavaBean.class);
        ear1.addModule((Archive)ejbJar1);
        MockArchiveManifest.addManifest(ear1);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ear1);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)unit);
        EnterpriseArchive ear2 = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple2.ear");
        JavaArchive ejbJar2 = this.createEjbJar("ejbJar2.jar", true, MySLSBean.class, BusinessInterface.class);
        ear2.addModule((Archive)ejbJar2);
        MockArchiveManifest.addManifest(ear2);
        unit = this.assertDeploy((Archive<?>)ear2);
        Class<?> mySLSBeanClass = this.getClass(MySLSBean.class, (DeploymentUnit)unit);
        Class<?> businessInterface = this.getClass(BusinessInterface.class, (DeploymentUnit)unit);
        Deployment deployment2 = this.initializeDeploymentBean((DeploymentUnit)unit);
        BeanDeploymentArchive bda2 = (BeanDeploymentArchive)deployment2.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(bda2, "simple2.ear");
        this.assertExpectedClasses(bda2, MySLSBean.class, BusinessInterface.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(mySLSBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(businessInterface));
        this.assertBDAId(bda2, "simple2.ear");
        this.assertExpectedClasses(bda2, MySLSBean.class, BusinessInterface.class);
        BeanDeploymentArchive bda1 = deployment2.loadBeanDeploymentArchive(plainJavaBeanClass);
        this.assertBDAId(bda1, "simple1.ear");
        this.assertExpectedClasses(bda1, PlainJavaBean.class);
        this.assertNoBeansXml(bda1);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment2.loadBeanDeploymentArchive(plainJavaBeanClass));
        this.assertBDAId(bda1, "simple1.ear");
        this.assertExpectedClasses(bda1, PlainJavaBean.class);
        this.assertNoBeansXml(bda1);
    }

    public void testWars() throws Exception {
        WebArchive war1 = this.createWar("simple1.war", true, ServletWebBean.class);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)war1);
        Class<?> servletWebBeanClass = this.getClass(ServletWebBean.class, (DeploymentUnit)unit);
        Deployment deployment1 = this.initializeDeploymentBean((DeploymentUnit)unit);
        WebArchive war2 = this.createWar("simple2.war", true, NotWBJsfBean.class);
        unit = this.assertDeploy((Archive<?>)war2);
        Class<?> notWBJsfBeanClass = this.getClass(NotWBJsfBean.class, (DeploymentUnit)unit);
        Deployment deployment2 = this.initializeDeploymentBean((DeploymentUnit)unit);
        BeanDeploymentArchive bda1 = (BeanDeploymentArchive)deployment1.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(bda1, "simple1.war");
        this.assertExpectedClasses(bda1, ServletWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda1, (Object)deployment1.loadBeanDeploymentArchive(servletWebBeanClass));
        this.assertBDAId(bda1, "simple1.war");
        this.assertExpectedClasses(bda1, ServletWebBean.class);
        BeanDeploymentArchive bda2 = (BeanDeploymentArchive)deployment2.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(bda2, "simple2.war");
        this.assertExpectedClasses(bda2, NotWBJsfBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda2, (Object)deployment2.loadBeanDeploymentArchive(notWBJsfBeanClass));
        this.assertBDAId(bda2, "simple2.war");
        this.assertExpectedClasses(bda2, NotWBJsfBean.class);
    }

    public void testMixedWars() throws Exception {
        WebArchive war1 = this.createWar("simple1.war", true, ServletWebBean.class);
        this.assertDeploy((Archive<?>)war1);
        WebArchive war2 = this.createWar("simple2.war", false, NotWBJsfBean.class);
        this.assertDeploy((Archive<?>)war2);
    }

    public void testWarWithLib() throws Exception {
        WebArchive war = this.createWarWithLib(true, true);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)war);
        Class<?> servletWebBeanClass = this.getClass(ServletWebBean.class, (DeploymentUnit)unit);
        Class<?> uiWebBeanClass = this.getClass(UIWebBean.class, (DeploymentUnit)unit);
        Deployment deployment = this.initializeDeploymentBean();
        BeanDeploymentArchive bda = (BeanDeploymentArchive)deployment.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(servletWebBeanClass));
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(uiWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
    }

    public void testWarWithLibWithoutXml() throws Exception {
        WebArchive war = this.createWarWithLib(true, false);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)war);
        Class<?> servletWebBeanClass = this.getClass(ServletWebBean.class, (DeploymentUnit)unit);
        Class<?> uiWebBeanClass = this.getClass(UIWebBean.class, (DeploymentUnit)unit);
        Deployment deployment = this.initializeDeploymentBean();
        BeanDeploymentArchive bda = (BeanDeploymentArchive)deployment.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(servletWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(uiWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(uiWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
    }

    public void testWarWithoutXmlWithLib() throws Exception {
        WebArchive war = this.createWarWithLib(false, true);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)war);
        Class<?> servletWebBeanClass = this.getClass(ServletWebBean.class, (DeploymentUnit)unit);
        Class<?> uiWebBeanClass = this.getClass(UIWebBean.class, (DeploymentUnit)unit);
        Deployment deployment = this.initializeDeploymentBean();
        BeanDeploymentArchive bda = (BeanDeploymentArchive)deployment.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, UIWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(servletWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(servletWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(uiWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
    }

    public void testWarWithMixedLibs() throws Exception {
        WebArchive war = this.createWarWithLibs(true, true, false);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)war);
        Class<?> servletWebBeanClass = this.getClass(ServletWebBean.class, (DeploymentUnit)unit);
        Class<?> uiWebBeanClass = this.getClass(UIWebBean.class, (DeploymentUnit)unit);
        Class<?> crmWebBeanClass = this.getClass(CrmWebBean.class, (DeploymentUnit)unit);
        Deployment deployment = this.initializeDeploymentBean();
        BeanDeploymentArchive bda = (BeanDeploymentArchive)deployment.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(servletWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(uiWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(crmWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class, CrmWebBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment.loadBeanDeploymentArchive(crmWebBeanClass));
        this.assertBDAId(bda, "simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class, CrmWebBean.class);
    }

    public void testWarInEars() throws Exception {
        EnterpriseArchive ear1 = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear1.ear");
        WebArchive war1 = this.createWar(true);
        ear1.addModule((Archive)war1);
        MockArchiveManifest.addManifest(ear1);
        this.assertDeploy((Archive<?>)ear1);
        EnterpriseArchive ear2 = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear2.ear");
        WebArchive war2 = this.createWar("simple.war", true, NotWBJsfBean.class);
        ear2.addModule((Archive)war2);
        MockArchiveManifest.addManifest(ear2);
        this.assertDeploy((Archive<?>)ear2);
    }

    public void testWarsInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear.ear");
        WebArchive war1 = this.createWar("simple1.war", true, ServletWebBean.class);
        ear.addModule((Archive)war1);
        WebArchive war2 = this.createWar("simple2.war", true, NotWBJsfBean.class);
        ear.addModule((Archive)war2);
        MockArchiveManifest.addManifest(ear);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ear);
        Iterator iterator = unit.getChildren().iterator();
        DeploymentUnit unit1 = (DeploymentUnit)iterator.next();
        DeploymentUnit unit2 = (DeploymentUnit)iterator.next();
        if (unit2.getName().contains("simple1.war")) {
            DeploymentUnit temp = unit2;
            unit2 = unit1;
            unit1 = temp;
        }
        Class<?> servletWebBeanClass = this.getClass(ServletWebBean.class, unit1);
        Class<?> notWBJsfBeanClass = this.getClass(NotWBJsfBean.class, unit2);
        Deployment deployment = this.initializeDeploymentBean();
        BeanDeploymentArchive bda1 = deployment.loadBeanDeploymentArchive(servletWebBeanClass);
        this.assertBDAId(bda1, "warinear.ear/simple1.war");
        this.assertExpectedClasses(bda1, ServletWebBean.class);
        BeanDeploymentArchive bda2 = deployment.loadBeanDeploymentArchive(notWBJsfBeanClass);
        this.assertBDAId(bda2, "warinear.ear/simple2.war");
        this.assertExpectedClasses(bda2, NotWBJsfBean.class);
    }

    public void testEjbJar_War() throws Exception {
        JavaArchive ejbJar = this.createEjbJar(true);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ejbJar);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)unit);
        Deployment deployment1 = this.initializeDeploymentBean((DeploymentUnit)unit);
        WebArchive war = this.createWar(true);
        unit = this.assertDeploy((Archive<?>)war);
        Deployment deployment2 = this.initializeDeploymentBean((DeploymentUnit)unit);
        BeanDeploymentArchive bda = (BeanDeploymentArchive)deployment1.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(bda, "ejb.jar");
        this.assertExpectedClasses(bda, PlainJavaBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment2.loadBeanDeploymentArchive(plainJavaBeanClass));
        this.assertBDAId(bda, "ejb.jar");
        this.assertExpectedClasses(bda, PlainJavaBean.class);
    }

    public void testEjbJarAndWarInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple.ear");
        JavaArchive ejbJar = this.createEjbJar(true);
        ear.addModule((Archive)ejbJar);
        WebArchive war = this.createWar(true);
        ear.addModule((Archive)war);
        MockArchiveManifest.addManifest(ear);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ear);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)unit);
        Iterator iterator = unit.getChildren().iterator();
        DeploymentUnit warUnit = null;
        while (!(warUnit = (DeploymentUnit)iterator.next()).getName().contains("simple.war")) {
        }
        Class<?> servletWebBeanClass = this.getClass(ServletWebBean.class, warUnit);
        Deployment deployment = this.initializeDeploymentBean();
        BeanDeploymentArchive bda = deployment.loadBeanDeploymentArchive(plainJavaBeanClass);
        this.assertBDAId(bda, "simple.ear");
        this.assertExpectedClasses(bda, PlainJavaBean.class);
        bda = deployment.loadBeanDeploymentArchive(servletWebBeanClass);
        this.assertBDAId(bda, "simple.ear/simple.war");
        this.assertExpectedClasses(bda, ServletWebBean.class);
    }

    public void testEjbJarInEar_War() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple.ear");
        JavaArchive ejbJar = this.createEjbJar(true);
        ear.addModule((Archive)ejbJar);
        MockArchiveManifest.addManifest(ear);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ear);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)unit);
        Deployment deployment1 = this.initializeDeploymentBean((DeploymentUnit)unit);
        WebArchive war = this.createWar(true);
        unit = this.assertDeploy((Archive<?>)war);
        Deployment deployment2 = this.initializeDeploymentBean((DeploymentUnit)unit);
        BeanDeploymentArchive bda = (BeanDeploymentArchive)deployment1.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(bda, "simple.ear");
        this.assertExpectedClasses(bda, PlainJavaBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment2.loadBeanDeploymentArchive(plainJavaBeanClass));
        this.assertBDAId(bda, "simple.ear");
        this.assertExpectedClasses(bda, PlainJavaBean.class);
    }

    public void testEjbJarInEar_WarWithLibInEar() throws Exception {
        EnterpriseArchive ejbEar = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"ejb.ear");
        JavaArchive ejbJar = this.createEjbJar(true);
        ejbEar.addModule((Archive)ejbJar);
        MockArchiveManifest.addManifest(ejbEar);
        VFSDeploymentUnit unit = this.assertDeploy((Archive<?>)ejbEar);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)unit);
        Deployment deployment1 = this.initializeDeploymentBean((DeploymentUnit)unit);
        EnterpriseArchive warEar = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"war.ear");
        WebArchive war = this.createWarWithLib(true, false);
        warEar.addModule((Archive)war);
        MockArchiveManifest.addManifest(warEar);
        unit = this.assertDeploy((Archive<?>)warEar);
        DeploymentUnit warUnit = (DeploymentUnit)unit.getChildren().iterator().next();
        Class<?> servletWebBeanClass = this.getClass(ServletWebBean.class, warUnit);
        Class<?> uiWebBeanClass = this.getClass(UIWebBean.class, warUnit);
        Deployment deployment2 = this.initializeDeploymentBean((DeploymentUnit)unit);
        BeanDeploymentArchive bda = (BeanDeploymentArchive)deployment1.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(bda, "ejb.ear");
        this.assertExpectedClasses(bda, PlainJavaBean.class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)deployment2.loadBeanDeploymentArchive(plainJavaBeanClass));
        this.assertBDAId(bda, "ejb.ear");
        this.assertExpectedClasses(bda, PlainJavaBean.class);
        bda = deployment2.loadBeanDeploymentArchive(servletWebBeanClass);
        String bdaName = "war.ear/simple.war";
        this.assertBDAId(bda, bdaName);
        this.assertExpectedClasses(bda, ServletWebBean.class);
        BeanDeploymentArchive bda2 = deployment2.loadBeanDeploymentArchive(uiWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)bda, (Object)bda2);
        this.assertBDAId(bda, bdaName);
        this.assertExpectedClasses(bda, ServletWebBean.class, UIWebBean.class);
    }

    public void testMultipleArchives() throws Exception {
        WebArchive war1 = this.createWar("web1.war", true, ServletWebBean.class);
        VFSDeploymentUnit war1Unit = this.assertDeploy((Archive<?>)war1);
        Deployment war1Deployment = this.initializeDeploymentBean((DeploymentUnit)war1Unit);
        BeanDeploymentArchive war1BDA = (BeanDeploymentArchive)war1Deployment.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(war1BDA, "web1.war");
        this.assertExpectedClasses(war1BDA, ServletWebBean.class);
        Class<?> servletWebBeanWar1Class = this.getClass(ServletWebBean.class, (DeploymentUnit)war1Unit);
        WebArchive war2 = this.createWar("web2.war", true, NotWBJsfBean.class);
        this.createLib((LibraryContainer<?>)war2, "crm.jar", false, CrmWebBean.class);
        VFSDeploymentUnit war2Unit = this.assertDeploy((Archive<?>)war2);
        Deployment war2Deployment = this.initializeDeploymentBean((DeploymentUnit)war2Unit);
        BeanDeploymentArchive war2BDA = (BeanDeploymentArchive)war2Deployment.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(war2BDA, "web2.war");
        this.assertExpectedClasses(war2BDA, NotWBJsfBean.class);
        Class<?> notWBJsfBeanWar2Class = this.getClass(NotWBJsfBean.class, (DeploymentUnit)war2Unit);
        Class<?> crmWebBeanWar2Class = this.getClass(CrmWebBean.class, (DeploymentUnit)war2Unit);
        JavaArchive ejbJar = this.createEjbJar("ejb.jar", true, BusinessInterface.class);
        VFSDeploymentUnit ejbJarUnit = this.assertDeploy((Archive<?>)ejbJar);
        Deployment ejbJarDeployment = this.initializeDeploymentBean((DeploymentUnit)ejbJarUnit);
        BeanDeploymentArchive ejbJarBDA = (BeanDeploymentArchive)ejbJarDeployment.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(ejbJarBDA, "ejb.jar");
        this.assertExpectedClasses(ejbJarBDA, BusinessInterface.class);
        Class<?> businessInterfaceClass = this.getClass(BusinessInterface.class, (DeploymentUnit)ejbJarUnit);
        EnterpriseArchive ear1 = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"full.ear");
        WebArchive warInEar1 = this.createWarWithLibs(false, true, true);
        ear1.addModule((Archive)warInEar1);
        ear1.addModule((Archive)war2);
        JavaArchive ejbJarInEar1 = this.createEjbJar("ejbInFullEar.jar", false, MySLSBean.class);
        ear1.addModule((Archive)ejbJarInEar1);
        this.createLib((LibraryContainer<?>)ear1, "lib1.jar", false, ExternalWebBean.class);
        this.createLib((LibraryContainer<?>)ear1, "lib2.jar", true, A.class);
        this.createLib((LibraryContainer<?>)ear1, "lib3.jar", false, B.class);
        MockArchiveManifest.addManifest(ear1);
        VFSDeploymentUnit ear1Unit = this.assertDeploy((Archive<?>)ear1);
        Deployment ear1Deployment = this.initializeDeploymentBean((DeploymentUnit)ear1Unit);
        BeanDeploymentArchive ear1BDA = null;
        BeanDeploymentArchive ear1War1BDA = null;
        BeanDeploymentArchive ear1War2BDA = null;
        for (BeanDeploymentArchive bda : ear1Deployment.getBeanDeploymentArchives()) {
            if (bda.getId().contains("simple.war")) {
                ear1War1BDA = bda;
                continue;
            }
            if (bda.getId().contains("web2.war")) {
                ear1War2BDA = bda;
                continue;
            }
            ear1BDA = bda;
        }
        this.assertBDAId(ear1BDA, "full.ear");
        this.assertExpectedClasses(ear1BDA, A.class);
        this.assertBDAId(ear1War1BDA, "full.ear/simple.war");
        this.assertExpectedClasses(ear1War1BDA, UIWebBean.class, CrmWebBean.class);
        this.assertBDAId(ear1War2BDA, "full.ear/web2.war");
        this.assertExpectedClasses(ear1War2BDA, NotWBJsfBean.class);
        Class<?> servletWebBeanEar1Class = null;
        Class<?> uiWebBeanEar1Class = null;
        Class<?> crmWebBeanEar1War1Class = null;
        Class<?> notWBJsfBeanEar1Class = null;
        Class<?> crmWebBeanEar1War2Class = null;
        for (DeploymentUnit ear1Child : ear1Unit.getChildren()) {
            if (ear1Child.getName().contains("simple.war")) {
                servletWebBeanEar1Class = this.getClass(ServletWebBean.class, ear1Child);
                uiWebBeanEar1Class = this.getClass(UIWebBean.class, ear1Child);
                crmWebBeanEar1War1Class = this.getClass(CrmWebBean.class, ear1Child);
                continue;
            }
            if (!ear1Child.getName().contains("web2.war")) continue;
            notWBJsfBeanEar1Class = this.getClass(NotWBJsfBean.class, ear1Child);
            crmWebBeanEar1War2Class = this.getClass(CrmWebBean.class, ear1Child);
        }
        Class<?> externalWebBeanClass = this.getClass(ExternalWebBean.class, (DeploymentUnit)ear1Unit);
        Class<?> aClass = this.getClass(A.class, (DeploymentUnit)ear1Unit);
        Class<?> bClass = this.getClass(B.class, (DeploymentUnit)ear1Unit);
        EnterpriseArchive ear2 = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"ejbWLibs.ear");
        JavaArchive ejbJarInEar2 = this.createEjbJar("ejbInEar2.jar", true, PlainJavaBean.class);
        ear2.addModule((Archive)ejbJarInEar2);
        this.createLib((LibraryContainer<?>)ear2, "lib1.jar", false, SomeUtil.class);
        this.createLib((LibraryContainer<?>)ear2, "lib2.jar", true, CrmWebBean.class);
        MockArchiveManifest.addManifest(ear2);
        VFSDeploymentUnit ear2Unit = this.assertDeploy((Archive<?>)ear2);
        Deployment ear2Deployment = this.initializeDeploymentBean((DeploymentUnit)ear2Unit);
        BeanDeploymentArchive ear2BDA = (BeanDeploymentArchive)ear2Deployment.getBeanDeploymentArchives().iterator().next();
        this.assertBDAId(ear2BDA, "ejbWLibs.ear");
        this.assertExpectedClasses(ear2BDA, PlainJavaBean.class, CrmWebBean.class);
        Class<?> plainJavaBeanClass = this.getClass(PlainJavaBean.class, (DeploymentUnit)ear2Unit);
        Class<?> someUtilClass = this.getClass(SomeUtil.class, (DeploymentUnit)ear2Unit);
        Class<?> crmWebBeanClass = this.getClass(CrmWebBean.class, (DeploymentUnit)ear2Unit);
        BeanDeploymentArchive bda = war1Deployment.loadBeanDeploymentArchive(servletWebBeanWar1Class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)war1BDA, (Object)bda);
        this.assertBDAId(war1BDA, "web1.war");
        this.assertExpectedClasses(war1BDA, ServletWebBean.class);
        bda = war2Deployment.loadBeanDeploymentArchive(notWBJsfBeanWar2Class);
        bda = war2Deployment.loadBeanDeploymentArchive(crmWebBeanWar2Class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)war2BDA, (Object)bda);
        this.assertBDAId(war2BDA, "web2.war");
        this.assertExpectedClasses(war2BDA, NotWBJsfBean.class, CrmWebBean.class);
        bda = ear1Deployment.loadBeanDeploymentArchive(servletWebBeanEar1Class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1War1BDA, (Object)bda);
        bda = ear1Deployment.loadBeanDeploymentArchive(uiWebBeanEar1Class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1War1BDA, (Object)bda);
        bda = ear1Deployment.loadBeanDeploymentArchive(crmWebBeanEar1War1Class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1War1BDA, (Object)bda);
        this.assertBDAId(ear1War1BDA, "full.ear/simple.war");
        this.assertExpectedClasses(ear1War1BDA, ServletWebBean.class, UIWebBean.class, CrmWebBean.class);
        bda = ear1Deployment.loadBeanDeploymentArchive(notWBJsfBeanEar1Class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1War2BDA, (Object)bda);
        bda = ear1Deployment.loadBeanDeploymentArchive(crmWebBeanEar1War2Class);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1War2BDA, (Object)bda);
        this.assertBDAId(ear1War2BDA, "full.ear/web2.war");
        this.assertExpectedClasses(ear1War2BDA, NotWBJsfBean.class, CrmWebBean.class);
        bda = ejbJarDeployment.loadBeanDeploymentArchive(businessInterfaceClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ejbJarBDA, (Object)bda);
        war1Deployment.loadBeanDeploymentArchive(businessInterfaceClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ejbJarBDA, (Object)bda);
        war2Deployment.loadBeanDeploymentArchive(businessInterfaceClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ejbJarBDA, (Object)bda);
        ear1Deployment.loadBeanDeploymentArchive(businessInterfaceClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ejbJarBDA, (Object)bda);
        war2Deployment.loadBeanDeploymentArchive(businessInterfaceClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ejbJarBDA, (Object)bda);
        this.assertBDAId(ejbJarBDA, "ejb.jar");
        this.assertExpectedClasses(ejbJarBDA, BusinessInterface.class);
        bda = ear1Deployment.loadBeanDeploymentArchive(aClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        bda = war1Deployment.loadBeanDeploymentArchive(aClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        bda = war2Deployment.loadBeanDeploymentArchive(aClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        bda = ejbJarDeployment.loadBeanDeploymentArchive(aClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        bda = ear2Deployment.loadBeanDeploymentArchive(aClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        this.assertBDAId(ear1BDA, "full.ear");
        this.assertExpectedClasses(ear1BDA, A.class);
        bda = ear2Deployment.loadBeanDeploymentArchive(plainJavaBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = ear2Deployment.loadBeanDeploymentArchive(crmWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = war1Deployment.loadBeanDeploymentArchive(plainJavaBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = war1Deployment.loadBeanDeploymentArchive(crmWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = war2Deployment.loadBeanDeploymentArchive(plainJavaBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = war2Deployment.loadBeanDeploymentArchive(crmWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = ejbJarDeployment.loadBeanDeploymentArchive(plainJavaBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = ejbJarDeployment.loadBeanDeploymentArchive(crmWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = ear1Deployment.loadBeanDeploymentArchive(plainJavaBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = ear1Deployment.loadBeanDeploymentArchive(crmWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        this.assertBDAId(ear2BDA, "ejbWLibs.ear");
        this.assertExpectedClasses(ear2BDA, PlainJavaBean.class, CrmWebBean.class);
        bda = war1Deployment.loadBeanDeploymentArchive(externalWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        this.assertBDAId(ear1BDA, "full.ear");
        this.assertExpectedClasses(ear1BDA, ExternalWebBean.class, A.class);
        bda = war2Deployment.loadBeanDeploymentArchive(externalWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        bda = ejbJarDeployment.loadBeanDeploymentArchive(externalWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        bda = ear1Deployment.loadBeanDeploymentArchive(externalWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        bda = ear2Deployment.loadBeanDeploymentArchive(externalWebBeanClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        this.assertBDAId(ear1BDA, "full.ear");
        this.assertExpectedClasses(ear1BDA, ExternalWebBean.class, A.class);
        bda = ear1Deployment.loadBeanDeploymentArchive(bClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        this.assertBDAId(ear1BDA, "full.ear");
        this.assertExpectedClasses(ear1BDA, ExternalWebBean.class, A.class, B.class);
        bda = war1Deployment.loadBeanDeploymentArchive(bClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        bda = war2Deployment.loadBeanDeploymentArchive(bClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        bda = ejbJarDeployment.loadBeanDeploymentArchive(bClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        bda = ear2Deployment.loadBeanDeploymentArchive(bClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear1BDA, (Object)bda);
        this.assertBDAId(ear1BDA, "full.ear");
        this.assertExpectedClasses(ear1BDA, ExternalWebBean.class, A.class, B.class);
        bda = ejbJarDeployment.loadBeanDeploymentArchive(someUtilClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        this.assertBDAId(ear2BDA, "ejbWLibs.ear");
        this.assertExpectedClasses(ear2BDA, PlainJavaBean.class, SomeUtil.class, CrmWebBean.class);
        bda = war1Deployment.loadBeanDeploymentArchive(someUtilClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = war2Deployment.loadBeanDeploymentArchive(someUtilClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = ear1Deployment.loadBeanDeploymentArchive(someUtilClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        bda = ear2Deployment.loadBeanDeploymentArchive(someUtilClass);
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)ear2BDA, (Object)bda);
        this.assertBDAId(ear2BDA, "ejbWLibs.ear");
        this.assertExpectedClasses(ear2BDA, PlainJavaBean.class, SomeUtil.class, CrmWebBean.class);
    }

    @Override
    protected Collection<String> getClasses(BeanDeploymentArchive bda) {
        return bda.getBeanClasses();
    }

    private Deployment initializeDeploymentBean(DeploymentUnit unit) {
        DeploymentImpl deployment = (DeploymentImpl)this.getBean(DeployersUtils.getDeploymentBeanName((DeploymentUnit)unit));
        deployment.initialize(this.bootstrap);
        return deployment;
    }

    private Deployment initializeDeploymentBean() {
        DeploymentImpl deployment = (DeploymentImpl)this.getBean(Deployment.class);
        deployment.initialize(this.bootstrap);
        return deployment;
    }

    private void assertNoBeansXml(BeanDeploymentArchive bda) {
        LoadBeanDeploymentArchiveTestCase.assertSame((Object)BeansXml.EMPTY_BEANS_XML, (Object)bda.getBeansXml());
    }

    private void assertBDAId(BeanDeploymentArchive bda, String name) {
        LoadBeanDeploymentArchiveTestCase.assertTrue((String)("BDA id \"" + bda.getId() + "\" expected to end with suffix \"" + name + "/}\""), (boolean)bda.getId().endsWith(name + "/}"));
    }

    private Class<?> getClass(Class<?> clazz, DeploymentUnit unit) throws ClassNotFoundException {
        ClassLoader classLoader = unit.getClassLoader();
        return classLoader.loadClass(clazz.getName());
    }
}

