/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.support.deployer;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.beans.metadata.spi.builder.ParameterMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.AbstractBootstrapInfoDeployer;
import org.jboss.weld.integration.deployer.env.BootstrapInfo;

public class MockBootDeployer
extends AbstractBootstrapInfoDeployer {
    public MockBootDeployer() {
        super(false);
        this.setDisableOptional(true);
        this.addOutput(BeanMetaData.class);
    }

    public void deployInternal(DeploymentUnit unit, BootstrapInfo info) throws DeploymentException {
        ValueMetaData ejbServicesValue = info.getEjbServices();
        if (ejbServicesValue == null) {
            throw new DeploymentException("Missing ejb services: " + unit);
        }
        ValueMetaData deploymentValue = info.getDeployment();
        if (deploymentValue == null) {
            throw new DeploymentException("Missing deployment: " + unit);
        }
        String unitName = unit.getName();
        String envName = unitName + "_JBossWebBeanDiscovery";
        BeanMetaDataBuilder envWrapper = BeanMetaDataBuilder.createBuilder((String)envName, (String)"org.jboss.test.deployers.support.WeldDEWrapper");
        envWrapper.addConstructorParameter(Deployment.class.getName(), deploymentValue);
        unit.addAttachment(envName + "_" + BeanMetaData.class.getSimpleName(), (Object)envWrapper.getBeanMetaData());
        String bootstrapName = DeployersUtils.getBootstrapBeanName((DeploymentUnit)unit);
        BeanMetaDataBuilder bootstrap = BeanMetaDataBuilder.createBuilder((String)bootstrapName, (String)"org.jboss.test.deployers.support.MockWeldBootstrap");
        bootstrap.setCreate("initialize");
        bootstrap.setStart("boot");
        bootstrap.setDestroy("shutdown");
        bootstrap.addDependency((Object)"RealTransactionManager");
        ParameterMetaDataBuilder install = bootstrap.addInstallWithParameters("createDepenencies", "DynamicDependencyCreator", null, ControllerState.CONFIGURED);
        install.addParameterMetaData(Object.class.getName(), bootstrapName);
        install.addParameterMetaData(Iterable.class.getName(), bootstrap.createInject(ejbServicesValue.getUnderlyingValue(), "ejbContainerNames"));
        install.addParameterMetaData(String.class.getName(), "Start");
        install.addParameterMetaData(String.class.getName(), "Start");
        ParameterMetaDataBuilder jndiInstall = bootstrap.addInstallWithParameters("bind", "JndiBinder");
        jndiInstall.addParameterMetaData(DeploymentUnit.class.getName(), (Object)unit);
        ParameterMetaDataBuilder jndiUninstall = bootstrap.addUninstallWithParameters("unbind", "JndiBinder");
        jndiUninstall.addParameterMetaData(DeploymentUnit.class.getName(), (Object)unit);
        unit.addAttachment(bootstrapName + "_" + BeanMetaData.class.getSimpleName(), (Object)bootstrap.getBeanMetaData());
    }
}

