/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.test.deployers.support.MockEmptyEjbServices;
import org.jboss.test.deployers.support.crm.CrmWebBean;
import org.jboss.test.deployers.support.ejb.BusinessInterface;
import org.jboss.test.deployers.support.ejb.MySLSBean;
import org.jboss.test.deployers.support.ext.ExternalWebBean;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.support.ui.UIWebBean;
import org.jboss.test.deployers.support.web.ServletWebBean;
import org.jboss.test.deployers.test.AbstractWeldTest;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.integration.deployer.DeployersUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymentTest
extends AbstractWeldTest {
    protected AbstractDeploymentTest(String name) {
        super(name);
    }

    protected void getArchives(List<BeanDeploymentArchive> result, Collection<BeanDeploymentArchive> archives) {
        for (BeanDeploymentArchive bda : archives) {
            if (result.contains(bda)) continue;
            result.add(bda);
            this.getArchives(result, bda.getBeanDeploymentArchives());
        }
    }

    protected abstract int getExpectedArchives();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleUsage() throws Exception {
        VirtualFile ear = this.createBasicEar(MockEmptyEjbServices.class);
        VFSDeploymentUnit topUnit = this.assertDeploy(ear);
        try {
            this.assertBean(DeployersUtils.getBootstrapBeanName((DeploymentUnit)topUnit), null, Object.class);
            Object bean = this.getBean(Deployment.class);
            Deployment deployment = (Deployment)this.assertInstanceOf(bean, Deployment.class, false);
            this.initializeDeployment(deployment);
            ArrayList<BeanDeploymentArchive> archives = new ArrayList<BeanDeploymentArchive>();
            this.getArchives(archives, deployment.getBeanDeploymentArchives());
            AbstractDeploymentTest.assertEquals((int)this.getExpectedArchives(), (int)archives.size());
            ArrayList<String> classes = new ArrayList<String>();
            for (BeanDeploymentArchive bad : archives) {
                for (String clazz : bad.getBeanClasses()) {
                    classes.add(clazz);
                }
            }
            HashSet<String> expected = new HashSet<String>();
            AbstractDeploymentTest.addExpectedClass(expected, BusinessInterface.class);
            AbstractDeploymentTest.addExpectedClass(expected, MySLSBean.class);
            AbstractDeploymentTest.addExpectedClass(expected, ExternalWebBean.class);
            AbstractDeploymentTest.addExpectedClass(expected, PlainJavaBean.class);
            AbstractDeploymentTest.addExpectedClass(expected, UIWebBean.class);
            AbstractDeploymentTest.addExpectedClass(expected, ServletWebBean.class);
            AbstractDeploymentTest.addExpectedClass(expected, CrmWebBean.class);
            AbstractDeploymentTest.assertEquals((String)"Illegal size or classes.", (int)classes.size(), (int)expected.size());
            for (String className : classes) {
                AbstractDeploymentTest.assertTrue((boolean)expected.remove(className));
            }
            this.assertEmpty("Should be emtpy, missing " + expected, expected);
            Class<?> newBeanClass = topUnit.getClassLoader().loadClass("org.jboss.test.deployers.support.MockTransactionServices");
            BeanDeploymentArchive newBDA = deployment.loadBeanDeploymentArchive(newBeanClass);
            this.assertNewBeanDeploymentArchive(archives, newBDA);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.undeploy((DeploymentUnit)topUnit);
            throw throwable;
        }
        this.undeploy((DeploymentUnit)topUnit);
    }

    protected abstract void assertNewBeanDeploymentArchive(List<BeanDeploymentArchive> var1, BeanDeploymentArchive var2);

    protected abstract void initializeDeployment(Deployment var1);

    private static void addExpectedResource(Set<String> expected, String unit) {
        AbstractDeploymentTest.addExpectedResource(expected, unit, "/META-INF/beans.xml");
    }

    private static void addExpectedResource(Set<String> expected, String unit, String suffix) {
        expected.add(unit + suffix);
    }

    private static void addExpectedClass(Set<String> expected, Class<?> clazz) {
        expected.add(clazz.getName());
    }
}

