/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import java.util.List;
import junit.framework.Test;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.version.Version;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.common.ejb.IEjbJarMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.test.deployers.test.AbstractWeldTest;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class PostDeployersTestCase
extends AbstractWeldTest {
    public PostDeployersTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return PostDeployersTestCase.suite(PostDeployersTestCase.class);
    }

    public void testSimpleJar() throws Exception {
        this.testJar("simple", false);
    }

    public void testPostJar() throws Exception {
        this.testJar("post", true);
    }

    public void testSimpleWar() throws Exception {
        this.testWar("simple", false, true);
    }

    public void testPostWar() throws Exception {
        this.testWar("post", true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEar() throws Exception {
        VirtualFile ear = this.createBasicEar();
        VFSDeploymentUnit earDU = this.assertDeploy(ear);
        try {
            this.assertClassLoading(true, (DeploymentUnit)earDU);
            DeploymentUnit jarDU = this.assertChild((DeploymentUnit)earDU, "ejbs.jar");
            this.assertWBInterceptor(jarDU);
            DeploymentUnit webDU = this.assertChild((DeploymentUnit)earDU, "simple.war");
            this.assertWBListener(webDU);
        }
        finally {
            this.undeploy((DeploymentUnit)earDU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testJar(String type, boolean testCL) throws Exception {
        VirtualFile topLevel = VFS.getChild((String)"ejbs.jar");
        this.createAssembledDirectory(topLevel).addPath("/weld/" + type + "/ejb");
        VFSDeploymentUnit topDU = this.assertDeploy(topLevel);
        try {
            this.assertClassLoading(testCL, (DeploymentUnit)topDU);
            this.assertWBInterceptor((DeploymentUnit)topDU);
        }
        finally {
            this.undeploy((DeploymentUnit)topDU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testWar(String type, boolean testCL, boolean testListner) throws Exception {
        VirtualFile topLevel = VFS.getChild((String)"web.war");
        this.createAssembledDirectory(topLevel).addPath("/weld/" + type + "/web");
        VFSDeploymentUnit topDU = this.assertDeploy(topLevel);
        try {
            if (testCL) {
                this.assertClassLoading(testCL, (DeploymentUnit)topDU);
            }
            if (testListner) {
                this.assertWBListener((DeploymentUnit)topDU);
            }
        }
        finally {
            this.undeploy((DeploymentUnit)topDU);
        }
    }

    protected void assertClassLoading(boolean equals, DeploymentUnit unit) {
        ClassLoadingMetaData clmd = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        PostDeployersTestCase.assertNotNull((Object)clmd);
        ClassLoadingMetaData classLoadingMetaData = new ClassLoadingMetaData();
        classLoadingMetaData.setName(unit.getName());
        classLoadingMetaData.setDomain(clmd.getDomain());
        classLoadingMetaData.setExportAll(ExportAll.NON_EMPTY);
        classLoadingMetaData.setImportAll(true);
        classLoadingMetaData.setVersion((Object)Version.DEFAULT_VERSION);
        classLoadingMetaData.setJ2seClassLoadingCompliance(false);
        PostDeployersTestCase.assertEquals((boolean)equals, (boolean)clmd.equals((Object)classLoadingMetaData));
    }

    protected void assertWBInterceptor(DeploymentUnit unit) {
        IEjbJarMetaData ejbmd = (IEjbJarMetaData)unit.getAttachment(JBossMetaData.class);
        PostDeployersTestCase.assertNotNull((Object)ejbmd);
        InterceptorsMetaData interceptors = ejbmd.getInterceptors();
        PostDeployersTestCase.assertNotNull((Object)interceptors);
        InterceptorMetaData imd = (InterceptorMetaData)interceptors.get("org.jboss.weld.integration.ejb.SessionBeanInterceptor");
        PostDeployersTestCase.assertNotNull((Object)imd);
    }

    protected void assertWBListener(DeploymentUnit unit) {
        JBossWebMetaData jbwmd = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        PostDeployersTestCase.assertNotNull((Object)jbwmd);
        List listeners = jbwmd.getListeners();
        PostDeployersTestCase.assertNotNull((Object)listeners);
        PostDeployersTestCase.assertEquals((int)2, (int)listeners.size());
        ListenerMetaData lmd = (ListenerMetaData)listeners.get(0);
        PostDeployersTestCase.assertNotNull((Object)lmd);
        PostDeployersTestCase.assertEquals((String)"org.jboss.weld.servlet.WeldListener", (String)lmd.getListenerClass());
    }
}

