/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import junit.framework.Test;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.test.AbstractWeldTest;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.DeployersUtils;

public class SmokeTestCase
extends AbstractWeldTest {
    public SmokeTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return SmokeTestCase.suite(SmokeTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testDeployment(VirtualFile app) throws Exception {
        VFSDeployment deployment = this.createVFSDeployment(app);
        DeployerClient mainDeployer = this.getDeployerClient();
        mainDeployer.addDeployment((Deployment)deployment);
        mainDeployer.process();
        try {
            DeploymentUnit du = this.getMainDeployerStructure().getDeploymentUnit(deployment.getName());
            ControllerContext context = (ControllerContext)du.getAttachment(ControllerContext.class);
            SmokeTestCase.assertNotNull((Object)context);
            SmokeTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context.getState());
            this.assertNoBean(DeployersUtils.getBootstrapBeanName((DeploymentUnit)du), null);
        }
        finally {
            mainDeployer.removeDeployment((Deployment)deployment);
            mainDeployer.process();
        }
    }

    public void testEar() throws Exception {
        VirtualFile ear = VFS.getChild((String)"jar-in-ear.ear");
        this.createAssembledDirectory(ear).addPath("/weld/jarwarinear").addPackage("simple.jar", PlainJavaBean.class).addPackage("simple.war/WEB-INF/classes", PlainJavaBean.class).addPath("simple.war", "/weld/warwowb/web");
        this.testDeployment(ear);
    }

    public void testWar() throws Exception {
        VirtualFile war = VFS.getChild((String)"w1.war");
        this.createAssembledDirectory(war).addPackage("WEB-INF/classes", PlainJavaBean.class).addPath("/weld/warwowb/web");
        this.testDeployment(war);
    }

    public void testJar() throws Exception {
        VirtualFile jar = VFS.getChild((String)"j1.jar");
        this.createAssembledDirectory(jar).addPackage(PlainJavaBean.class);
        this.testDeployment(jar);
    }
}

