/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env;

import java.util.ArrayList;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;
import org.jboss.weld.integration.injection.WeldInjector;
import org.jboss.weld.integration.util.IdFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContainterIntegrationDeployer
extends AbstractSimpleRealDeployer<JBossWebMetaData> {
    public WebContainterIntegrationDeployer() {
        super(JBossWebMetaData.class);
        this.setOutput(JBossWebMetaData.class);
    }

    public void deploy(DeploymentUnit unit, JBossWebMetaData deployment) throws DeploymentException {
        if (DeployersUtils.isBootstrapBeanPresent(unit) && unit.getAttachment("WELD_FILES") != null) {
            String injectorName = unit.getName() + "_WBInjector";
            String bootstrapBeanName = DeployersUtils.getBootstrapBeanName(unit);
            BeanMetaDataBuilder weldInjector = BeanMetaDataBuilder.createBuilder((String)injectorName, (String)WeldInjector.class.getName());
            weldInjector.addConstructorParameter(BootstrapBean.class.getName(), weldInjector.createInject((Object)bootstrapBeanName));
            weldInjector.addConstructorParameter(String.class.getName(), IdFactory.getIdFromClassLoader(unit.getClassLoader()));
            weldInjector.setDestroy("cleanup");
            unit.addAttachment(injectorName + "_" + BeanMetaData.class.getSimpleName(), (Object)weldInjector.getBeanMetaData());
            ArrayList<String> depends = deployment.getDepends();
            if (depends == null) {
                depends = new ArrayList<String>();
                deployment.setDepends(depends);
            }
            depends.add(bootstrapBeanName);
        }
    }
}

