/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.deployers.support.MockArchiveManifest;
import org.jboss.test.deployers.support.crm.CrmWebBean;
import org.jboss.test.deployers.support.ejb.BusinessInterface;
import org.jboss.test.deployers.support.ejb.MySLSBean;
import org.jboss.test.deployers.support.ext.ExternalWebBean;
import org.jboss.test.deployers.support.jar.PlainJavaBean;
import org.jboss.test.deployers.support.jsf.NotWBJsfBean;
import org.jboss.test.deployers.support.ui.UIWebBean;
import org.jboss.test.deployers.support.util.SomeUtil;
import org.jboss.test.deployers.support.web.ServletWebBean;
import org.jboss.test.deployers.test.AbstractEnvironmentTest;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSingleArchiveTest<E>
extends AbstractEnvironmentTest<E> {
    protected DeploymentUnit unit;

    public AbstractSingleArchiveTest(String name) {
        super(name);
    }

    public void testEjbJar() throws Exception {
        JavaArchive ejbJar = this.createEjbJar(true);
        this.unit = this.assertDeploy((Archive<?>)ejbJar);
        E environment = this.assertSingleEnvironment("ejb.jar");
        this.assertExpectedClasses(environment, PlainJavaBean.class);
        this.assertExpectedResources(environment, "ejb.jar");
    }

    public void testEjbJarWithoutXml() throws Exception {
        JavaArchive ejbJar = this.createEjbJar(false);
        this.unit = this.assertDeploy((Archive<?>)ejbJar);
        this.assertEmptyEnvironment();
    }

    public void testEjbJarInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple.ear");
        JavaArchive ejbJar = this.createEjbJar(true);
        ear.addModule((Archive)ejbJar);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        E environment = this.assertSingleEnvironment("simple.ear");
        this.assertExpectedClasses(environment, PlainJavaBean.class);
        this.assertExpectedResources(environment, this.unit.getSimpleName() + "/ejb.jar");
    }

    public void testEjbJarWithoutXmlInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple.ear");
        JavaArchive ejbJar = this.createEjbJar(false);
        ear.addModule((Archive)ejbJar);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        this.assertEmptyEnvironment();
    }

    public void testEjbJarsInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple.ear");
        JavaArchive ejbJar1 = this.createEjbJar("ejbJar1.jar", true, PlainJavaBean.class);
        ear.addModule((Archive)ejbJar1);
        JavaArchive ejbJar2 = this.createEjbJar("ejbJar2.jar", true, MySLSBean.class, BusinessInterface.class);
        ear.addModule((Archive)ejbJar2);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        E environment = this.assertSingleEnvironment("simple.ear");
        this.assertExpectedClasses(environment, PlainJavaBean.class, MySLSBean.class, BusinessInterface.class);
        this.assertExpectedResources(environment, "simple.ear/ejbJar1.jar", "simple.ear/ejbJar2.jar");
    }

    public void testMixedEjbJarsInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple.ear");
        JavaArchive ejbJar1 = this.createEjbJar("ejbJar1.jar", false, PlainJavaBean.class);
        ear.addModule((Archive)ejbJar1);
        JavaArchive ejbJar2 = this.createEjbJar("ejbJar2.jar", true, MySLSBean.class, BusinessInterface.class);
        ear.addModule((Archive)ejbJar2);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        E environment = this.assertSingleEnvironment("simple.ear");
        this.assertExpectedClasses(environment, MySLSBean.class, BusinessInterface.class);
        this.assertExpectedResources(environment, "simple.ear/ejbJar2.jar");
    }

    public void testEjbJarsWithoutXmlInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple.ear");
        JavaArchive ejbJar1 = this.createEjbJar("ejbJar1.jar", false, PlainJavaBean.class);
        ear.addModule((Archive)ejbJar1);
        JavaArchive ejbJar2 = this.createEjbJar("ejbJar2.jar", false, MySLSBean.class, BusinessInterface.class);
        ear.addModule((Archive)ejbJar2);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        this.assertEmptyEnvironment();
    }

    public void testWar() throws Exception {
        WebArchive war = this.createWar(true);
        this.unit = this.assertDeploy((Archive<?>)war);
        E environment = this.assertSingleEnvironment("simple.war");
        this.assertExpectedClasses(environment, ServletWebBean.class);
        this.assertExpectedWarResources(environment, this.unit.getSimpleName(), true, new String[0]);
    }

    public void testWarWithLib() throws Exception {
        WebArchive war = this.createWarWithLib(true, true);
        this.unit = this.assertDeploy((Archive<?>)war);
        E environment = this.assertSingleEnvironment("simple.war");
        this.assertExpectedClasses(environment, ServletWebBean.class, UIWebBean.class);
        this.assertExpectedWarResources(environment, this.unit.getSimpleName(), true, "lib.jar");
    }

    public void testWarWithLibs() throws Exception {
        WebArchive war = this.createWarWithLibs(true, true, true);
        this.unit = this.assertDeploy((Archive<?>)war);
        E environment = this.assertSingleEnvironment("simple.war");
        this.assertExpectedClasses(environment, ServletWebBean.class, UIWebBean.class, CrmWebBean.class);
        this.assertExpectedWarResources(environment, this.unit.getSimpleName(), true, "lib1.jar", "lib2.jar");
    }

    public void testWarWithLibWithoutXml() throws Exception {
        WebArchive war = this.createWarWithLib(true, false);
        this.unit = this.assertDeploy((Archive<?>)war);
        E environment = this.assertSingleEnvironment("simple.war");
        this.assertExpectedClasses(environment, ServletWebBean.class);
        this.assertExpectedWarResources(environment, this.unit.getSimpleName(), true, new String[0]);
    }

    public void testWarWithLibsWithoutXml() throws Exception {
        WebArchive war = this.createWarWithLibs(true, false, false);
        this.unit = this.assertDeploy((Archive<?>)war);
        E environment = this.assertSingleEnvironment("simple.war");
        this.assertExpectedClasses(environment, ServletWebBean.class);
        this.assertExpectedWarResources(environment, this.unit.getSimpleName(), true, new String[0]);
    }

    public void testWarWithMixedLibs() throws Exception {
        WebArchive war = this.createWarWithLibs(true, true, false);
        this.unit = this.assertDeploy((Archive<?>)war);
        E environment = this.assertSingleEnvironment("simple.war");
        this.assertExpectedClasses(environment, ServletWebBean.class, UIWebBean.class);
        this.assertExpectedWarResources(environment, this.unit.getSimpleName(), true, "lib1.jar");
    }

    public void testWarWithoutXmlWithLib() throws Exception {
        WebArchive war = this.createWarWithLib(false, true);
        this.unit = this.assertDeploy((Archive<?>)war);
        E environment = this.assertSingleEnvironment("simple.war");
        this.assertExpectedClasses(environment, UIWebBean.class);
        this.assertExpectedWarResources(environment, this.unit.getSimpleName(), false, "lib.jar");
    }

    public void testWarWithoutXmlWithLibs() throws Exception {
        WebArchive war = this.createWarWithLibs(false, true, true);
        this.unit = this.assertDeploy((Archive<?>)war);
        E environment = this.assertSingleEnvironment("simple.war");
        this.assertExpectedClasses(environment, UIWebBean.class, CrmWebBean.class);
        this.assertExpectedWarResources(environment, this.unit.getSimpleName(), false, "lib1.jar", "lib2.jar");
    }

    public void testWarWithoutXmlWithLibWithoutXml() throws Exception {
        WebArchive war = this.createWarWithLib(false, false);
        this.unit = this.assertDeploy((Archive<?>)war);
        this.assertEmptyEnvironment();
    }

    public void testWarWithoutXmlWithMixedLibs() throws Exception {
        WebArchive war = this.createWarWithLibs(false, true, false);
        this.unit = this.assertDeploy((Archive<?>)war);
        E environment = this.assertSingleEnvironment("simple.war");
        this.assertExpectedClasses(environment, UIWebBean.class);
        this.assertExpectedWarResources(environment, this.unit.getSimpleName(), false, "lib1.jar");
    }

    public void testWarWithoutXmlWithLibsWithoutXml() throws Exception {
        WebArchive war = this.createWarWithLibs(false, false, false);
        this.unit = this.assertDeploy((Archive<?>)war);
        this.assertEmptyEnvironment();
    }

    public void testWarWithoutXml() throws Exception {
        WebArchive war = this.createWar(false);
        this.unit = this.assertDeploy((Archive<?>)war);
        this.assertEmptyEnvironment();
    }

    public void testWarInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear.ear");
        WebArchive war = this.createWar(true);
        ear.addModule((Archive)war);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        E environment = this.assertSingleEnvironment("warinear.ear/simple.war");
        this.assertExpectedClasses(environment, ServletWebBean.class);
        this.assertExpectedWarResources(environment, "warinear.ear/simple.war", true, new String[0]);
    }

    public void testWarsInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear.ear");
        WebArchive war = this.createWar("simple1.war", true, ServletWebBean.class);
        ear.addModule((Archive)war);
        war = this.createWar("simple2.war", true, NotWBJsfBean.class);
        ear.addModule((Archive)war);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        this.assertWarsInEar();
    }

    protected abstract void assertWarsInEar();

    public void testMixedWarsInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear.ear");
        WebArchive war = this.createWar("simple1.war", true, ServletWebBean.class);
        ear.addModule((Archive)war);
        war = this.createWar("simple2.war", false, NotWBJsfBean.class);
        ear.addModule((Archive)war);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        E environment = this.assertSingleEnvironment("warinear.ear/simple1.war");
        this.assertExpectedClasses(environment, ServletWebBean.class);
        this.assertExpectedWarResources(environment, "warinear.ear/simple1.war", true, new String[0]);
    }

    public void testWarsWithoutXmlInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear.ear");
        WebArchive war = this.createWar("simple1.war", false, ServletWebBean.class);
        ear.addModule((Archive)war);
        war = this.createWar("simple2.war", false, NotWBJsfBean.class);
        ear.addModule((Archive)war);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        this.assertEmptyEnvironment();
    }

    public void testWarWithLibInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear.ear");
        WebArchive war = this.createWarWithLib(true, true);
        ear.addModule((Archive)war);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        E environment = this.assertSingleEnvironment("warinear.ear/simple.war");
        this.assertExpectedClasses(environment, ServletWebBean.class, UIWebBean.class);
        this.assertExpectedWarResources(environment, "warinear.ear/simple.war", true, "lib.jar");
    }

    public void testWarWithLibWithoutXmlInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear.ear");
        WebArchive war = this.createWarWithLib(true, false);
        ear.addModule((Archive)war);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        E environment = this.assertSingleEnvironment("warinear.ear/simple.war");
        this.assertExpectedClasses(environment, ServletWebBean.class);
        this.assertExpectedWarResources(environment, "warinear.ear/simple.war", true, new String[0]);
    }

    public void testWarWithoutXmlWithLibWithoutXmlInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear.ear");
        WebArchive war = this.createWarWithLib(false, false);
        ear.addModule((Archive)war);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        this.assertEmptyEnvironment();
    }

    public void testWarWithoutXmlWithLibInEar() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"warinear.ear");
        WebArchive war = this.createWarWithLib(false, true);
        ear.addModule((Archive)war);
        MockArchiveManifest.addManifest(ear);
        this.unit = this.assertDeploy((Archive<?>)ear);
        E environment = this.assertSingleEnvironment("warinear.ear/simple.war");
        this.assertExpectedClasses(environment, UIWebBean.class);
        this.assertExpectedWarResources(environment, "warinear.ear/simple.war", false, "lib.jar");
    }

    public void testBasicEar() throws Exception {
        VirtualFile ear = this.createBasicEar();
        this.unit = this.assertDeploy(ear);
        this.assertBasicEar();
    }

    protected abstract void assertBasicEar();

    public void testBasicEarFullCDI() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"top-level.ear");
        this.createLib((LibraryContainer<?>)ear, "util.jar", true, SomeUtil.class);
        this.createLib((LibraryContainer<?>)ear, "ext.jar", true, ExternalWebBean.class);
        JavaArchive ejbJar = this.createEjbJar("simple.jar", true, PlainJavaBean.class);
        ear.addModule((Archive)ejbJar);
        ejbJar = this.createEjbJar("ejbs.jar", true, MySLSBean.class, BusinessInterface.class);
        ear.addModule((Archive)ejbJar);
        WebArchive war = this.createWar("simple.war", true, ServletWebBean.class);
        this.createLib((LibraryContainer<?>)war, "ui.jar", true, UIWebBean.class);
        ear.addModule((Archive)war);
        war = this.createWar("crm.war", true, NotWBJsfBean.class);
        this.createLib((LibraryContainer<?>)war, "crm.jar", true, CrmWebBean.class);
        ear.addModule((Archive)war);
        this.unit = this.assertDeploy((Archive<?>)ear);
        this.assertBasicEarFullCDI();
    }

    protected abstract void assertBasicEarFullCDI();

    public void testBasicEarWithoutXml() throws Exception {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"simple.ear");
        this.createLib((LibraryContainer<?>)ear, "util.jar", false, SomeUtil.class);
        this.createLib((LibraryContainer<?>)ear, "ext.jar", false, ExternalWebBean.class);
        JavaArchive ejbJar = this.createEjbJar("simple.jar", false, PlainJavaBean.class);
        ear.addModule((Archive)ejbJar);
        ejbJar = this.createEjbJar("ejbs.jar", false, MySLSBean.class, BusinessInterface.class);
        ear.addModule((Archive)ejbJar);
        WebArchive war = this.createWar("simple.war", false, ServletWebBean.class);
        this.createLib((LibraryContainer<?>)war, "ui.jar", false, UIWebBean.class);
        ear.addModule((Archive)war);
        war = this.createWar("crm.war", false, NotWBJsfBean.class);
        this.createLib((LibraryContainer<?>)war, "crm.jar", false, CrmWebBean.class);
        ear.addModule((Archive)war);
        this.unit = this.assertDeploy((Archive<?>)ear);
        this.assertBasicEarWithoutXml();
    }

    private void addExpectedResource(Set<String> expected, String unit) {
        this.addExpectedResource(expected, unit, "/META-INF/beans.xml");
    }

    private void addExpectedResource(Set<String> expected, String unit, String suffix) {
        expected.add(unit + suffix);
    }

    private void assertExpectedResources(E environment, Set<String> expected) {
        Collection<URL> weldXml = this.getResources(environment);
        AbstractSingleArchiveTest.assertNotNull(weldXml);
        AbstractSingleArchiveTest.assertTrue((String)"Unexpected empty weld XML collection", (expected.isEmpty() || !weldXml.isEmpty() ? 1 : 0) != 0);
        for (URL url : weldXml) {
            boolean found = false;
            Iterator<String> iter = expected.iterator();
            while (iter.hasNext()) {
                String expectedURL = iter.next();
                if (!url.toExternalForm().endsWith(expectedURL)) continue;
                iter.remove();
                found = true;
                break;
            }
            AbstractSingleArchiveTest.assertTrue((String)("Unexpected wb url: " + url), (boolean)found);
        }
        this.assertEmpty("Should be emtpy, missing " + expected, expected);
    }

    protected void assertExpectedResources(E environment, String ... units) {
        HashSet<String> expected = new HashSet<String>();
        for (String unit : units) {
            this.addExpectedResource(expected, unit);
        }
        this.assertExpectedResources(environment, expected);
    }

    protected void assertExpectedWarResources(E environment, String warUnit, boolean warResourceExpected, String ... units) {
        HashSet<String> expected = new HashSet<String>();
        if (warResourceExpected) {
            this.addExpectedResource(expected, warUnit, "/WEB-INF/beans.xml");
        }
        for (String unit : units) {
            this.addExpectedResource(expected, warUnit, "/WEB-INF/lib/" + unit + "/META-INF/beans.xml");
        }
        this.assertExpectedResources(environment, expected);
    }

    protected abstract Collection<URL> getResources(E var1);

    protected abstract void assertBasicEarWithoutXml();

    protected abstract void assertEmptyEnvironment();

    protected abstract E assertSingleEnvironment(String var1);
}

