/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.test;

import java.lang.reflect.Field;
import java.util.Map;
import javax.naming.Context;
import junit.framework.Test;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.plugins.tracker.AbstractContextRegistry;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.deployers.support.deployer.CheckableJndiBinder;
import org.jboss.test.deployers.test.AbstractWeldTest;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.DeployersUtils;

public class BootDeployerTestCase
extends AbstractWeldTest {
    private KernelController controller;

    public BootDeployerTestCase(String name) {
        super(name);
        this.setAutowireCandidate(true);
    }

    public static Test suite() {
        return BootDeployerTestCase.suite(BootDeployerTestCase.class);
    }

    @Inject(bean="jboss.kernel:service=KernelController")
    public void setController(KernelController controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testBootstrap(VirtualFile ear) throws Exception {
        Object bootstrap;
        Context bmContext = (Context)this.assertInstanceOf(CheckableJndiBinder.ROOT.lookup("cdi"), Context.class, false);
        String duSimpleName = null;
        VFSDeployment deployment = this.createVFSDeployment(ear);
        DeployerClient mainDeployer = this.getDeployerClient();
        mainDeployer.addDeployment((Deployment)deployment);
        mainDeployer.process();
        ControllerContext wbContext = null;
        try {
            DeploymentUnit earDU = this.getMainDeployerStructure().getDeploymentUnit(deployment.getName());
            String bootName = DeployersUtils.getBootstrapBeanName((DeploymentUnit)earDU);
            bootstrap = this.getBean(bootName, null);
            this.assertInstanceOf(bootstrap, "org.jboss.test.deployers.support.CheckableBootstrap", earDU.getClassLoader());
            BootDeployerTestCase.assertTrue((boolean)this.invoke(bootstrap, "Create"));
            BootDeployerTestCase.assertFalse((boolean)this.invoke(bootstrap, "Boot"));
            BootDeployerTestCase.assertFalse((boolean)this.invoke(bootstrap, "Shutdown"));
            KernelControllerContext ejb = this.deploy((BeanMetaData)new AbstractBeanMetaData("EjbContainer#1", Object.class.getName()));
            try {
                BootDeployerTestCase.assertTrue((boolean)ejb.getState().equals((Object)ControllerState.INSTALLED));
                BootDeployerTestCase.assertTrue((boolean)this.invoke(bootstrap, "Create"));
                BootDeployerTestCase.assertTrue((boolean)this.invoke(bootstrap, "Boot"));
                BootDeployerTestCase.assertFalse((boolean)this.invoke(bootstrap, "Shutdown"));
                duSimpleName = earDU.getSimpleName();
                Context context = (Context)this.assertInstanceOf(bmContext.lookup(duSimpleName), Context.class, false);
                BootDeployerTestCase.assertSame((Object)"Bootstrap Dummy", (Object)context.lookup("bootstrap"));
                Class<?> wbClass = earDU.getClassLoader().loadClass("org.jboss.test.deployers.support.CheckableBootstrap");
                wbContext = this.controller.getContextByClass(wbClass);
                BootDeployerTestCase.assertNotNull((Object)wbContext);
                BootDeployerTestCase.assertSame((Object)bootstrap, (Object)wbContext.getTarget());
                Object var14_13 = null;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                this.undeploy(ejb);
                throw throwable;
            }
            this.undeploy(ejb);
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            mainDeployer.removeDeployment((Deployment)deployment);
            mainDeployer.process();
            BootDeployerTestCase.assertNull((Object)bmContext.lookup(duSimpleName));
            if (wbContext != null) {
                BootDeployerTestCase.assertNull((Object)wbContext.getTarget());
            }
            Field registryField = AbstractController.class.getDeclaredField("registry");
            registryField.setAccessible(true);
            Object registry = registryField.get(this.controller);
            Field mapField = AbstractContextRegistry.class.getDeclaredField("contextsByClass");
            mapField.setAccessible(true);
            Map map = (Map)mapField.get(registry);
            for (Class clazz : map.keySet()) {
                String className = clazz.getName();
                if (!"org.jboss.test.deployers.support.CheckableBootstrap".equals(className)) continue;
                Object value = map.get(clazz);
                BootDeployerTestCase.fail((String)("" + value));
            }
            throw throwable;
        }
        mainDeployer.removeDeployment((Deployment)deployment);
        mainDeployer.process();
        BootDeployerTestCase.assertNull((Object)bmContext.lookup(duSimpleName));
        if (wbContext != null) {
            BootDeployerTestCase.assertNull((Object)wbContext.getTarget());
        }
        Field registryField = AbstractController.class.getDeclaredField("registry");
        registryField.setAccessible(true);
        Object registry = registryField.get(this.controller);
        Field mapField = AbstractContextRegistry.class.getDeclaredField("contextsByClass");
        mapField.setAccessible(true);
        Map map = (Map)mapField.get(registry);
        for (Class clazz : map.keySet()) {
            String className = clazz.getName();
            if (!"org.jboss.test.deployers.support.CheckableBootstrap".equals(className)) continue;
            Object value = map.get(clazz);
            BootDeployerTestCase.fail((String)("" + value));
        }
        BootDeployerTestCase.assertTrue((boolean)this.invoke(bootstrap, "Shutdown"));
    }

    public void testEar() throws Exception {
        this.testBootstrap(this.createBasicEar());
    }

    public void testWarInEar() throws Exception {
        this.testBootstrap(this.createWarInEar());
    }
}

