/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.qa.junit;

import com.arjuna.qa.junit.TestRunnerServlet;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class TestRunnerXMLServlet
extends TestRunnerServlet {
    @Override
    protected String getContentType() {
        return "text/xml";
    }

    @Override
    public void doStatus(PrintWriter writer, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        PrintWriter printWriter;
        CharArrayWriter charArrayWriter;
        DOMDocument report = new DOMDocument();
        DOMElement testsuite = new DOMElement("testsuite");
        report.setRootElement((Element)testsuite);
        testsuite.addAttribute("name", this._testSuiteClassName);
        testsuite.addAttribute("errors", Integer.toString(this._errorTests.size()));
        testsuite.addAttribute("failures", Integer.toString(this._failedTests.size()));
        testsuite.addAttribute("hostname", request.getServerName());
        testsuite.addAttribute("tests", Integer.toString(this._testResult != null ? this._testResult.runCount() : 0));
        testsuite.addAttribute("timestamp", new Date().toString());
        DOMElement properties = new DOMElement("properties");
        testsuite.add((Element)properties);
        DOMElement status = this.newPropertyDOMElement("status");
        properties.add((Element)status);
        if (this._runnerThread == null || !this._runnerThread.isAlive()) {
            if (this._passedTests.isEmpty() && this._failedTests.isEmpty() && this._errorTests.isEmpty()) {
                status.addAttribute("value", "stopped");
            } else {
                status.addAttribute("value", "finished");
            }
        } else if (this._currentTest != null) {
            status.addAttribute("value", "running");
            properties.add((Element)this.newPropertyDOMElement("current-test", this._currentTest.toString()));
        }
        long totalDuration = 0L;
        if (!this._passedTests.isEmpty()) {
            for (TestRunnerServlet.PassedTest passedTest : this._passedTests) {
                totalDuration += passedTest.duration;
                testsuite.add((Element)this.newTestcase(passedTest.description.getClass().getName(), passedTest.description.toString(), passedTest.duration));
            }
        }
        if (!this._failedTests.isEmpty()) {
            for (TestRunnerServlet.FailedTest failedTest : this._failedTests) {
                totalDuration += failedTest.duration;
                charArrayWriter = new CharArrayWriter();
                printWriter = new PrintWriter((Writer)charArrayWriter, true);
                failedTest.assertionFailedError.printStackTrace(printWriter);
                printWriter.close();
                charArrayWriter.close();
                testsuite.add((Element)this.newFailedTestcase(failedTest.description.getClass().getName(), failedTest.description.toString(), failedTest.duration, failedTest.assertionFailedError.getMessage(), charArrayWriter.toString()));
            }
        }
        if (!this._errorTests.isEmpty()) {
            for (TestRunnerServlet.ErrorTest errorTest : this._errorTests) {
                totalDuration += errorTest.duration;
                charArrayWriter = new CharArrayWriter();
                printWriter = new PrintWriter((Writer)charArrayWriter, true);
                errorTest.throwable.printStackTrace(printWriter);
                printWriter.close();
                charArrayWriter.close();
                System.out.println("charArrayWriter.toString()=" + charArrayWriter.toString());
                testsuite.add((Element)this.newErrorTestcase(errorTest.description.getClass().getName(), errorTest.description.toString(), errorTest.duration, errorTest.throwable.getMessage(), charArrayWriter.toString()));
            }
        }
        testsuite.add(new DOMElement("system-out").addCDATA(""));
        testsuite.add(new DOMElement("system-err").addCDATA(""));
        testsuite.addAttribute("time", Float.toString((float)totalDuration / 1000.0f));
        XMLWriter outputter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
        try {
            outputter.write((Element)testsuite);
            outputter.close();
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private DOMElement newPropertyDOMElement(String name) {
        return this.newPropertyDOMElement(name, null);
    }

    private DOMElement newPropertyDOMElement(String name, String value) {
        DOMElement property = new DOMElement("property");
        property.addAttribute("name", name);
        if (value != null) {
            property.addAttribute("value", value);
        }
        return property;
    }

    private DOMElement newTestcase(String classname, String name, long duration) {
        return this.newTestcase(classname, name, duration, null, null, null);
    }

    private DOMElement newFailedTestcase(String classname, String name, long duration, String failureMessage, String failureDetail) {
        return this.newTestcase(classname, name, duration, "junit.framework.AssertionFailedError", failureMessage, failureDetail);
    }

    private DOMElement newErrorTestcase(String classname, String name, long duration, String failureMessage, String failureDetail) {
        return this.newTestcase(classname, name, duration, "junit.framework.throwable", failureMessage, failureDetail);
    }

    private DOMElement newTestcase(String classname, String name, long duration, String failureMessage, String failureType, String failureDetail) {
        DOMElement testcase = new DOMElement("testcase");
        testcase.addAttribute("classname", classname);
        testcase.addAttribute("name", name);
        testcase.addAttribute("time", Float.toString((float)duration / 1000.0f));
        if (failureMessage != null) {
            DOMElement failure = new DOMElement("failure");
            testcase.add((Element)failure);
            failure.addAttribute("message", failureMessage);
            if (failureType != null) {
                failure.addAttribute("type", failureType);
            }
            if (failureDetail != null) {
                failure.addCDATA(failureDetail);
            }
        }
        return testcase;
    }
}

