/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.qa.junit;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.AssertionFailedError;
import junit.framework.TestResult;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class TestRunnerServlet
extends HttpServlet {
    protected List _passedTests = new LinkedList();
    protected List _failedTests = new LinkedList();
    protected List _errorTests = new LinkedList();
    protected Description _currentTest = null;
    protected String _testSuiteClassName = null;
    protected RunnerThread _runnerThread = null;
    protected TestResult _testResult = null;
    protected boolean _running = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._testSuiteClassName = config.getInitParameter("TestSuiteClassName");
    }

    protected String getContentType() {
        return "text/html";
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            PrintWriter writer = response.getWriter();
            response.setContentType(this.getContentType());
            response.setHeader("Cache-Control", "no-cache");
            if (request.getParameter("failednumber") != null) {
                this.doStatusFailed(writer, request, response);
            } else if (request.getParameter("errornumber") != null) {
                this.doStatusError(writer, request, response);
            } else {
                this.doStatus(writer, request, response);
            }
        }
        catch (Exception exception) {
            this.log("Test Runner: doGet failed", exception);
            response.sendError(500, exception.toString());
        }
        catch (Error error) {
            this.log("Test Runner: doGet failed", error);
            response.sendError(500, error.toString());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            PrintWriter writer = response.getWriter();
            response.setContentType(this.getContentType());
            response.setHeader("Cache-Control", "no-cache");
            if (this._runnerThread == null || !this._runnerThread.isAlive()) {
                this._runnerThread = new RunnerThread();
                this._runnerThread.start();
            }
            if (request.getParameter("failednumber") != null) {
                this.doStatusFailed(writer, request, response);
            } else if (request.getParameter("errornumber") != null) {
                this.doStatusError(writer, request, response);
            } else {
                this.doStatus(writer, request, response);
            }
        }
        catch (Exception exception) {
            this.log("Test Runner: doPost failed", exception);
            response.sendError(500, exception.toString());
        }
        catch (Error error) {
            this.log("Test Runner: doPost failed", error);
            response.sendError(500, error.toString());
        }
    }

    public void doStatus(PrintWriter writer, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.println("<TITLE>Test Runner</TITLE>");
        writer.println("</HEAD>");
        writer.println("<BODY bgcolor=\"white\" style=\"font-family: Arial, Helvetica, sans-serif\">");
        writer.println("<DIV style=\"font-family: Arial, Helvetica, sans-serif; font-size: large\">&nbsp;<BR>Test Runner: Status<BR>&nbsp;</DIV>");
        writer.println("<TABLE width=\"100%\">");
        writer.println("<TR><TD colspan=\"3\" align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Status</TD></TR>");
        writer.println("<TR>");
        writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Test suite class:</TD>");
        writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif\">" + this._testSuiteClassName + "</TD>");
        writer.println("</TR>");
        if (this._runnerThread == null || !this._runnerThread.isAlive()) {
            writer.println("<TR>");
            writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Action:</TD>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
            writer.print("<FORM method=\"POST\" action=\"" + request.getRequestURL() + "\">");
            writer.print("<INPUT type=\"button\" value=\"run\" onclick=\"this.form.submit()\">");
            writer.print("</FORM>");
            writer.println("</TD>");
            writer.println("</TR>");
        } else {
            writer.println("<TR>");
            writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Action:</TD>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
            writer.print("<FORM method=\"GET\" action=\"" + request.getRequestURL() + "\">");
            writer.print("<INPUT type=\"button\" value=\"reload\" onclick=\"this.form.submit()\">");
            writer.print("</FORM>");
            writer.println("</TD>");
            writer.println("</TR>");
            if (this._currentTest != null) {
                writer.println("<TR>");
                writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Current test:</TD>");
                writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
                TestRunnerServlet.encode(writer, this._currentTest.toString());
                writer.println("</TD>");
                writer.println("</TR>");
            }
        }
        writer.println("</TR>");
        writer.println("<TR>");
        writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Passed count:</TD>");
        writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif\">" + this._passedTests.size() + "</TD>");
        writer.println("</TR>");
        writer.println("<TR>");
        writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Failed count:</TD>");
        writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif\">" + this._failedTests.size() + "</TD>");
        writer.println("</TR>");
        writer.println("<TR>");
        writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Error count:</TD>");
        writer.println("<TD style=\"font-family: Arial, Helvetica, sans-serif\">" + this._errorTests.size() + "</TD>");
        writer.println("</TR>");
        writer.println("</TABLE>");
        if (!this._passedTests.isEmpty()) {
            writer.println("<BR>");
            writer.println("<TABLE width=\"100%\">");
            writer.println("<TR><TD colspan=\"3\" align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Passes</TD></TR>");
            writer.println("<TR>");
            writer.println("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Test</TD>");
            writer.println("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Duration</TD>");
            writer.println("</TR>");
            for (PassedTest passedTest : this._passedTests) {
                writer.println("<TR>");
                writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
                TestRunnerServlet.encode(writer, passedTest.description.toString());
                writer.println("</TD>");
                writer.print("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif\">" + passedTest.duration + " ms</TD>");
                writer.println("</TR>");
            }
            writer.println("</TABLE>");
        }
        if (!this._failedTests.isEmpty()) {
            writer.println("<BR>");
            writer.println("<TABLE width=\"100%\">");
            writer.println("<TR><TD colspan=\"3\" align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Failures</TD></TR>");
            writer.println("<TR>");
            writer.println("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Test</TD>");
            writer.println("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Duration</TD>");
            writer.println("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Message</TD>");
            writer.println("</TR>");
            int failedNumber = 0;
            for (FailedTest failedTest : this._failedTests) {
                writer.println("<TR>");
                writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
                writer.print("<A href=\"" + request.getRequestURL() + "?failednumber=" + failedNumber + "\">");
                TestRunnerServlet.encode(writer, failedTest.description.toString());
                writer.print("</A>");
                writer.println("</TD>");
                writer.print("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif\">" + failedTest.duration + " ms</TD>");
                writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
                TestRunnerServlet.encode(writer, failedTest.assertionFailedError.getMessage());
                writer.println("</TD>");
                writer.println("</TR>");
                ++failedNumber;
            }
            writer.println("</TABLE>");
            writer.println("<BR>");
        }
        if (!this._errorTests.isEmpty()) {
            writer.println("<TABLE width=\"100%\">");
            writer.println("<TR>");
            writer.println("<TR><TD colspan=\"3\" align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Errors</TD></TR>");
            writer.println("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Test</TD>");
            writer.println("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Duration</TD>");
            writer.println("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Exception/Error</TD>");
            writer.println("</TR>");
            int errorNumber = 0;
            for (ErrorTest errorTest : this._errorTests) {
                writer.println("<TR>");
                writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
                writer.print("<A href=\"" + request.getRequestURL() + "?errornumber=" + errorNumber + "\">");
                TestRunnerServlet.encode(writer, errorTest.description.toString());
                writer.print("</A>");
                writer.println("</TD>");
                writer.print("<TD align=\"center\" style=\"font-family: Arial, Helvetica, sans-serif\">" + errorTest.duration + " ms</TD>");
                writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
                TestRunnerServlet.encode(writer, errorTest.throwable.toString());
                writer.println("</TD>");
                writer.println("</TR>");
                ++errorNumber;
            }
            writer.println("</TABLE>");
        }
        writer.println("</BODY>");
        writer.println("</HTML>");
    }

    public void doStatusFailed(PrintWriter writer, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        int failedIndex = 0;
        FailedTest failedTest = null;
        try {
            String failedIndexString = request.getParameter("failednumber");
            failedIndex = Integer.parseInt(failedIndexString);
            failedTest = (FailedTest)this._failedTests.get(failedIndex);
        }
        catch (Exception exception) {
            failedTest = null;
        }
        if (failedTest != null) {
            writer.println("<HTML>");
            writer.println("<HEAD>");
            writer.println("<TITLE>Test Runner</TITLE>");
            writer.println("</HEAD>");
            writer.println("<BODY bgcolor=\"white\" style=\"font-family: Arial, Helvetica, sans-serif\">");
            writer.println("<DIV style=\"font-family: Arial, Helvetica, sans-serif; font-size: large\">&nbsp;<BR>Test Runner: Failed Status<BR>&nbsp;</DIV>");
            writer.println("<TABLE>");
            writer.print("<TR>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Test:</TD>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
            TestRunnerServlet.encode(writer, failedTest.description.toString());
            writer.println("</TD>");
            writer.println("</TR>");
            writer.println("<TR>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Duration:</TD>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">" + failedTest.duration + " ms</TD>");
            writer.println("</TR>");
            writer.println("<TR>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Message:</TD>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
            TestRunnerServlet.encode(writer, failedTest.assertionFailedError.getMessage());
            writer.println("</TD>");
            writer.println("</TR>");
            writer.print("<TR>");
            writer.print("<TD colspan=\"2\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Stack trace:</TD>");
            writer.println("</TR>");
            writer.println("<TR>");
            writer.println("<TD colspan=\"2\" style=\"font-family: Arial, Helvetica, sans-serif\">");
            writer.println("<PRE>");
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter((Writer)charArrayWriter, true);
            failedTest.assertionFailedError.printStackTrace(printWriter);
            printWriter.close();
            charArrayWriter.close();
            TestRunnerServlet.encode(writer, charArrayWriter.toString());
            writer.println("</PRE>");
            writer.println("</TD>");
            writer.println("</TR>");
            writer.println("</TABLE>");
            writer.println("<TABLE width=\"100%\">");
            writer.println("<TR>");
            writer.println("<TD align=\"left\" width=\"33%\" style=\"font-family: Arial, Helvetica, sans-serif\">");
            if (failedIndex > 0) {
                writer.println("<A href=\"" + request.getRequestURL() + "?failednumber=" + (failedIndex - 1) + "\">previous</A>");
            } else {
                writer.print("&nbsp;");
            }
            writer.println("</TD>");
            writer.println("<TD align=\"center\" width=\"33%\" style=\"font-family: Arial, Helvetica, sans-serif\">");
            writer.println("<A href=\"" + request.getRequestURL() + "\">all</A>");
            writer.println("</TD>");
            writer.println("<TD align=\"right\" width=\"33%\" style=\"font-family: Arial, Helvetica, sans-serif\">");
            if (failedIndex < this._failedTests.size() - 1) {
                writer.println("<A href=\"" + request.getRequestURL() + "?failednumber=" + (failedIndex + 1) + "\">next</A>");
            } else {
                writer.print("&nbsp;");
            }
            writer.println("</TD>");
            writer.println("</TR>");
            writer.println("</TABLE>");
            writer.println("</BODY>");
            writer.println("</HTML>");
        } else {
            this.doStatus(writer, request, response);
        }
    }

    public void doStatusError(PrintWriter writer, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        int errorIndex = 0;
        ErrorTest errorTest = null;
        try {
            String errorIndexString = request.getParameter("errornumber");
            errorIndex = Integer.parseInt(errorIndexString);
            errorTest = (ErrorTest)this._errorTests.get(errorIndex);
        }
        catch (Exception exception) {
            errorTest = null;
        }
        if (errorTest != null) {
            writer.println("<HTML>");
            writer.println("<HEAD>");
            writer.println("<TITLE>Test Runner</TITLE>");
            writer.println("</HEAD>");
            writer.println("<BODY bgcolor=\"white\" style=\"font-family: Arial, Helvetica, sans-serif\">");
            writer.println("<DIV style=\"font-family: Arial, Helvetica, sans-serif; font-size: large\">&nbsp;<BR>Test Runner: Error Status<BR>&nbsp;</DIV>");
            writer.println("<TABLE>");
            writer.print("<TR>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Test:</TD>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
            TestRunnerServlet.encode(writer, errorTest.description.toString());
            writer.println("</TD>");
            writer.println("</TR>");
            writer.println("<TR>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Duration:</TD>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">" + errorTest.duration + " ms</TD>");
            writer.println("</TR>");
            writer.println("<TR>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Exception/error:</TD>");
            writer.print("<TD style=\"font-family: Arial, Helvetica, sans-serif\">");
            TestRunnerServlet.encode(writer, errorTest.throwable.toString());
            writer.println("</TD>");
            writer.println("</TR>");
            writer.print("<TR>");
            writer.print("<TD colspan=\"2\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: bold\">Stack trace:</TD>");
            writer.println("</TR>");
            writer.println("<TR>");
            writer.println("<TD colspan=\"2\" style=\"font-family: Arial, Helvetica, sans-serif\">");
            writer.println("<PRE>");
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter((Writer)charArrayWriter, true);
            errorTest.throwable.printStackTrace(printWriter);
            printWriter.close();
            charArrayWriter.close();
            TestRunnerServlet.encode(writer, charArrayWriter.toString());
            writer.println("</PRE>");
            writer.println("</TD>");
            writer.println("</TR>");
            writer.println("</TABLE>");
            writer.println("<TABLE width=\"100%\">");
            writer.println("<TR>");
            writer.println("<TD align=\"left\" width=\"33%\" style=\"font-family: Arial, Helvetica, sans-serif\">");
            if (errorIndex > 0) {
                writer.println("<A href=\"" + request.getRequestURL() + "?errornumber=" + (errorIndex - 1) + "\">previous</A>");
            } else {
                writer.print("&nbsp;");
            }
            writer.println("</TD>");
            writer.println("<TD align=\"center\" width=\"33%\" style=\"font-family: Arial, Helvetica, sans-serif\">");
            writer.println("<A href=\"" + request.getRequestURL() + "\">all</A>");
            writer.println("</TD>");
            writer.println("<TD align=\"right\" width=\"33%\" style=\"font-family: Arial, Helvetica, sans-serif\">");
            if (errorIndex < this._errorTests.size() - 1) {
                writer.println("<A href=\"" + request.getRequestURL() + "?errornumber=" + (errorIndex + 1) + "\">next</A>");
            } else {
                writer.print("&nbsp;");
            }
            writer.println("</TD>");
            writer.println("</TR>");
            writer.println("</TABLE>");
            writer.println("</BODY>");
            writer.println("</HTML>");
        } else {
            this.doStatus(writer, request, response);
        }
    }

    protected static void encode(PrintWriter writer, String string) {
        if (string != null) {
            char[] chars = string.toCharArray();
            for (int index = 0; index < chars.length; ++index) {
                if (chars[index] == '<') {
                    writer.print("&lt;");
                    continue;
                }
                if (chars[index] == '>') {
                    writer.print("&gt;");
                    continue;
                }
                if (chars[index] == '&') {
                    writer.print("&amp;");
                    continue;
                }
                writer.print(chars[index]);
            }
        } else {
            writer.print("null");
        }
    }

    private class BasicTestListener
    extends RunListener {
        private long _startTime = 0L;
        private boolean _fail = false;

        private BasicTestListener() {
        }

        public void testRunStarted(Description description) throws Exception {
            super.testRunStarted(description);
            TestRunnerServlet.this._running = true;
        }

        public void testRunFinished(Result result) throws Exception {
            super.testRunFinished(result);
            TestRunnerServlet.this._running = false;
        }

        public void testStarted(Description description) throws Exception {
            super.testStarted(description);
            this._startTime = System.currentTimeMillis();
            TestRunnerServlet.this._currentTest = description;
        }

        public void testFinished(Description description) throws Exception {
            super.testFinished(description);
            if (!this._fail) {
                PassedTest passedTest = new PassedTest();
                passedTest.description = description;
                passedTest.duration = System.currentTimeMillis() - this._startTime;
                TestRunnerServlet.this._passedTests.add(passedTest);
                TestRunnerServlet.this._currentTest = null;
            }
        }

        public void testFailure(Failure failure) throws Exception {
            super.testFailure(failure);
            this._fail = true;
            Throwable _throwable = failure.getException();
            _throwable.printStackTrace(System.out);
            if (_throwable instanceof AssertionFailedError) {
                FailedTest failedTest = new FailedTest();
                failedTest.description = failure.getDescription();
                failedTest.duration = System.currentTimeMillis() - this._startTime;
                failedTest.assertionFailedError = (AssertionFailedError)_throwable;
                TestRunnerServlet.this._failedTests.add(failedTest);
            } else {
                ErrorTest errorTest = new ErrorTest();
                errorTest.description = failure.getDescription();
                errorTest.duration = System.currentTimeMillis() - this._startTime;
                errorTest.throwable = _throwable;
                TestRunnerServlet.this._errorTests.add(errorTest);
            }
            TestRunnerServlet.this._currentTest = null;
        }

        public void testAssumptionFailure(Failure failure) {
            super.testAssumptionFailure(failure);
            this._fail = true;
            Throwable _throwable = failure.getException();
            _throwable.printStackTrace(System.out);
            ErrorTest errorTest = new ErrorTest();
            errorTest.description = failure.getDescription();
            errorTest.duration = System.currentTimeMillis() - this._startTime;
            errorTest.throwable = _throwable;
            TestRunnerServlet.this._errorTests.add(errorTest);
            TestRunnerServlet.this._currentTest = null;
        }

        public void testIgnored(Description description) throws Exception {
            super.testIgnored(description);
            TestRunnerServlet.this._currentTest = null;
        }
    }

    protected class RunnerThread
    extends Thread {
        RunnerThread() {
            super("JUnit Runner Thread");
        }

        @Override
        public void run() {
            try {
                TestRunnerServlet.this._passedTests.clear();
                TestRunnerServlet.this._failedTests.clear();
                TestRunnerServlet.this._errorTests.clear();
                Class<?> testSuiteClass = Class.forName(TestRunnerServlet.this._testSuiteClassName);
                BasicTestListener testListener = new BasicTestListener();
                JUnitCore core = new JUnitCore();
                core.addListener((RunListener)testListener);
                core.run(new Class[]{testSuiteClass});
            }
            catch (Exception exception) {
                TestRunnerServlet.this.log("Runner Thread: run failed", exception);
            }
            catch (Error error) {
                TestRunnerServlet.this.log("Runner Thread: run failed", error);
            }
        }
    }

    protected class ErrorTest {
        public Description description;
        public long duration;
        public Throwable throwable;

        protected ErrorTest() {
        }
    }

    protected class FailedTest {
        public Description description;
        public long duration;
        public AssertionFailedError assertionFailedError;

        protected FailedTest() {
        }
    }

    protected class PassedTest {
        public Description description;
        public long duration;

        protected PassedTest() {
        }
    }
}

