/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;

public class CollectionPropertyHandler
extends AbstractPropertyHandler {
    private boolean isSet = false;

    public CollectionPropertyHandler(PropertyInfo propertyInfo, TypeInfo propertyType) {
        super(propertyInfo, propertyType);
        TypeInfo set = propertyType.getTypeInfoFactory().getTypeInfo(Set.class);
        if (set.isAssignableFrom(propertyType)) {
            this.isSet = true;
        }
    }

    public void handle(PropertyInfo propertyInfo, TypeInfo propertyType, Object parent, Object child, QName qName) {
        BeanAdapter beanAdapter = (BeanAdapter)parent;
        Collection<Object> c = null;
        try {
            if (propertyInfo.getGetter() != null) {
                c = (HashSet<Object>)beanAdapter.get(propertyInfo);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + qName + " error getting collection property " + propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent), t);
        }
        if (c == null) {
            ClassInfo collectionType = (ClassInfo)propertyType;
            if (!Modifier.isAbstract(collectionType.getModifiers())) {
                try {
                    ConstructorInfo constructor = collectionType.getDeclaredConstructor(null);
                    if (constructor == null) {
                        for (ConstructorInfo ctor : collectionType.getDeclaredConstructors()) {
                            if (ctor.getParameterTypes().length != 0) continue;
                            this.log.warn((Object)("ClassInfo.getDeclaredConstructor(null) didn't work for " + collectionType.getName() + ", found the default ctor in ClassInfo.getDeclaredConstructors()"));
                            constructor = ctor;
                            break;
                        }
                        if (constructor == null) {
                            throw new NoSuchMethodException("Default constructor not found for " + collectionType.getName());
                        }
                    }
                    c = (Collection)constructor.newInstance(null);
                }
                catch (Throwable t) {
                    throw new RuntimeException("QName " + qName + " error creating collection: " + propertyType.getName(), t);
                }
            } else {
                c = this.isSet ? new HashSet<Object>() : new ArrayList();
            }
            try {
                beanAdapter.set(propertyInfo, c);
            }
            catch (Throwable t) {
                throw new RuntimeException("QName " + qName + " error setting collection property " + propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent) + " with value " + BuilderUtil.toDebugString(c), t);
            }
        }
        try {
            c.add(child);
        }
        catch (Exception e) {
            throw new RuntimeException("QName " + qName + " error adding " + BuilderUtil.toDebugString(child) + " to collection " + BuilderUtil.toDebugString(c), e);
        }
    }
}

