/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaResolverConfigMBean;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class SchemaResolverConfig
implements SchemaResolverConfigMBean {
    private static final Logger log = Logger.getLogger(SchemaResolverConfig.class);
    protected static DefaultSchemaResolver resolver = (DefaultSchemaResolver)SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    protected Properties schemaInitializers;
    protected Properties schemaLocations;
    protected Properties parseAnnotations;
    protected Properties bindingClasses;
    protected Properties bindingClassesByLocation;

    public boolean getCacheResolvedSchemas() {
        return resolver.isCacheResolvedSchemas();
    }

    public void setCacheResolvedSchemas(boolean flag) {
        resolver.setCacheResolvedSchemas(flag);
    }

    public Properties getSchemaInitializers() {
        return this.schemaInitializers;
    }

    public void setSchemaInitializers(Properties schemaInitializers) {
        this.schemaInitializers = schemaInitializers;
        if (schemaInitializers != null && schemaInitializers.size() != 0) {
            for (Map.Entry<Object, Object> entry : schemaInitializers.entrySet()) {
                String namespace = (String)entry.getKey();
                String initializer = (String)entry.getValue();
                try {
                    resolver.addSchemaInitializer(namespace, initializer);
                }
                catch (Exception ignored) {
                    log.debug((Object)"Ignored: ", (Throwable)ignored);
                }
            }
        }
    }

    public Properties getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(Properties schemaLocations) {
        this.schemaLocations = schemaLocations;
        if (schemaLocations != null && schemaLocations.size() != 0) {
            for (Map.Entry<Object, Object> entry : schemaLocations.entrySet()) {
                String namespace = (String)entry.getKey();
                String location = (String)entry.getValue();
                resolver.addSchemaLocation(namespace, location);
            }
        }
    }

    public Properties getParseAnnotations() {
        return this.parseAnnotations;
    }

    public void setParseAnnotations(Properties parseAnnotations) {
        this.parseAnnotations = parseAnnotations;
        if (parseAnnotations != null && parseAnnotations.size() != 0) {
            for (Map.Entry<Object, Object> entry : parseAnnotations.entrySet()) {
                String namespace = (String)entry.getKey();
                String value = (String)entry.getValue();
                Boolean booleanValue = Boolean.valueOf(value);
                resolver.addSchemaParseAnnotations(namespace, booleanValue);
            }
        }
    }

    public Properties getBindingClassesByLocations() {
        return this.bindingClassesByLocation;
    }

    public void setBindingClassesByLocations(Properties bindingClassesByLocation) {
        this.bindingClassesByLocation = bindingClassesByLocation;
        if (bindingClassesByLocation != null && bindingClassesByLocation.size() != 0) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (Map.Entry<Object, Object> entry : bindingClassesByLocation.entrySet()) {
                String schemaLocation = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    Class<?> clazz = loader.loadClass(value);
                    resolver.addClassBindingForLocation(schemaLocation, clazz);
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Failed to load class: " + value), (Throwable)e);
                }
            }
        }
    }

    public Properties getBindingClasses() {
        return this.bindingClasses;
    }

    public void setBindingClasses(Properties bindingClasses) {
        this.bindingClasses = bindingClasses;
        if (bindingClasses != null && bindingClasses.size() != 0) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (Map.Entry<Object, Object> entry : bindingClasses.entrySet()) {
                String namespace = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    Class<?> clazz = loader.loadClass(value);
                    resolver.addClassBinding(namespace, clazz);
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Failed to load class: " + value), (Throwable)e);
                }
            }
        }
    }
}

