/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.namespace.QName;
import org.jboss.reflect.spi.EnumConstantInfo;
import org.jboss.reflect.spi.EnumInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.BuilderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumValueAdapter
implements ValueAdapter {
    private QName qName;
    private Map<Object, Object> valid;

    public EnumValueAdapter(QName qName, EnumInfo enumInfo, TypeInfo enumType) {
        if (enumInfo == null) {
            throw new IllegalArgumentException("Null enumInfo");
        }
        if (enumType == null) {
            throw new IllegalArgumentException("Null enumType");
        }
        this.qName = qName;
        EnumConstantInfo[] constants = enumInfo.getEnumConstants();
        this.valid = new HashMap<Object, Object>(constants.length);
        for (EnumConstantInfo constant : constants) {
            String enumValue = constant.getName();
            XmlEnumValue xmlEnumValue = (XmlEnumValue)constant.getUnderlyingAnnotation(XmlEnumValue.class);
            if (xmlEnumValue != null) {
                enumValue = xmlEnumValue.value();
            }
            Object key = enumValue;
            try {
                key = enumType.convertValue((Object)enumValue, false);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error for enum " + enumInfo.getName() + " unable to convert " + enumValue + " to " + enumType.getName());
            }
            Object value = constant.getValue();
            this.valid.put(key, value);
        }
    }

    public Map<Object, Object> getMapping() {
        return this.valid;
    }

    @Override
    public Object cast(Object o, Class c) {
        if (o == null) {
            return null;
        }
        Object result = this.valid.get(o);
        if (result == null) {
            if (this.qName == null) {
                throw new RuntimeException("Invalid value " + BuilderUtil.toDebugString(o) + " valid are " + this.valid.keySet());
            }
            throw new RuntimeException("Invalid value " + BuilderUtil.toDebugString(o) + " for " + this.qName + " valid are " + this.valid.keySet());
        }
        return result;
    }
}

