/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.config;

import com.sun.faces.spi.AnnotationProvider;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.servlet.ServletContext;
import org.jboss.mc.servlet.vdf.api.BaseAttachmentVDFConnector;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.annotations.spi.Element;
import org.jboss.util.collection.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAnnotationProvider
extends AnnotationProvider {
    private static final Set<Class<? extends Annotation>> JSF_ANNOTATIONS = new WeakSet();
    private AnnotationIndex index;
    private AnnotationProvider defaultProvider;

    public JBossAnnotationProvider(ServletContext sc, AnnotationProvider defaultProvider) {
        super(sc);
        this.defaultProvider = defaultProvider;
        this.index = this.readIndex(sc);
    }

    protected AnnotationIndex readIndex(ServletContext sc) {
        BaseAttachmentVDFConnector<AnnotationIndex> connector = new BaseAttachmentVDFConnector<AnnotationIndex>(sc){

            protected Class<AnnotationIndex> getAttachmentType() {
                return AnnotationIndex.class;
            }
        };
        return (AnnotationIndex)connector.getUtility();
    }

    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(Set<URL> urls) {
        if (this.index != null) {
            HashMap result = new HashMap();
            for (Class<? extends Annotation> annotationClass : JSF_ANNOTATIONS) {
                this.fillResults(result, annotationClass, null);
            }
            return result;
        }
        return this.defaultProvider.getAnnotatedClasses(urls);
    }

    protected <T extends Annotation> void fillResults(Map<Class<? extends Annotation>, Set<Class<?>>> result, Class<T> annotationClass, URL url) {
        ElementType[] types;
        HashSet<Class> classes = new HashSet<Class>();
        result.put(annotationClass, classes);
        Target target = annotationClass.getAnnotation(Target.class);
        for (ElementType type : types = target.value()) {
            Set set = this.index.getAnnotatedClasses(url, annotationClass, type);
            for (Element elt : set) {
                classes.add(elt.getOwner());
            }
        }
    }

    static {
        JSF_ANNOTATIONS.add(FacesComponent.class);
        JSF_ANNOTATIONS.add(FacesConverter.class);
        JSF_ANNOTATIONS.add(FacesRenderer.class);
        JSF_ANNOTATIONS.add(ManagedBean.class);
        JSF_ANNOTATIONS.add(NamedEvent.class);
        JSF_ANNOTATIONS.add(FacesBehavior.class);
        JSF_ANNOTATIONS.add(FacesBehaviorRenderer.class);
    }
}

