/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.jsf.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.web.deployers.MergedJBossWebMetaDataDeployer;

/**
 * Adds the values from the JSF configuration's web.xml to the deployment.
 *
 * @author Stan Silvert
 * @since 1.0
 */
public class JSFSharedWebMetaDataDeployer extends AbstractSimpleVFSRealDeployer<JSFImplMetaData>
{
    /**
     * Create a new deployer.
     */
    public JSFSharedWebMetaDataDeployer()
    {
        super(JSFImplMetaData.class);
        setStage(DeploymentStages.POST_CLASSLOADER);
        addRequiredInput(JBossWebMetaData.class);

        // make sure this runs after the MergedJBossWebMetaDataDeployer
        addInput(MergedJBossWebMetaDataDeployer.WEB_ORDER_ATTACHMENT_NAME);
        addInput(MergedJBossWebMetaDataDeployer.WEB_OVERLAYS_ATTACHMENT_NAME);
        addInput(MergedJBossWebMetaDataDeployer.WEB_SCIS_ATTACHMENT_NAME);

        setOutput(JBossWebMetaData.class);
    }

    
    @Override
    public void deploy(VFSDeploymentUnit unit, JSFImplMetaData jsfImpl) throws DeploymentException
    {
       JBossWebMetaData webMetaData = unit.getAttachment(JBossWebMetaData.class);
       mergeWebMetaData(webMetaData, jsfImpl.getSharedWebXml());
    }
    
    // merge the JBoss shared web.xml with the JSF impl web.xml
    private void mergeWebMetaData(JBossWebMetaData webMetaData, Web30MetaData jsfImplWebMetaData)
    {
        if (jsfImplWebMetaData.getFilters() != null)
        {
            FiltersMetaData filters = webMetaData.getFilters();
            if (filters == null)
            {
                filters = new FiltersMetaData();
            }
            filters.addAll(jsfImplWebMetaData.getFilters());
            webMetaData.setFilters(filters);
        }

        if (jsfImplWebMetaData.getFilterMappings() != null)
        {
            List<FilterMappingMetaData> filterMappings = webMetaData.getFilterMappings();
            if (filterMappings == null)
            {
                filterMappings = new ArrayList<FilterMappingMetaData>();
            }
            filterMappings.addAll(jsfImplWebMetaData.getFilterMappings());
            webMetaData.setFilterMappings(filterMappings);
        }

        if (jsfImplWebMetaData.getServlets() != null)
        {
            JBossServletsMetaData servlets = webMetaData.getServlets();
            if (servlets == null)
            {
                servlets = new JBossServletsMetaData();
            }
            ServletsMetaData servletsMD = jsfImplWebMetaData.getServlets();
            servlets.addAll(makeJBossServletsMetaData(servletsMD));
            webMetaData.setServlets(servlets);
        }

        if (jsfImplWebMetaData.getServletMappings() != null)
        {
            List<ServletMappingMetaData> servletMappings = webMetaData.getServletMappings();
            if (servletMappings == null)
            {
                servletMappings = new ArrayList<ServletMappingMetaData>();
            }
            servletMappings.addAll(jsfImplWebMetaData.getServletMappings());
            webMetaData.setServletMappings(servletMappings);
        }

        if (jsfImplWebMetaData.getContextParams() != null)
        {
            List<ParamValueMetaData> contextParams = webMetaData.getContextParams();
            if (contextParams == null)
            {
                contextParams = new ArrayList<ParamValueMetaData>();
            }

            contextParams.addAll(jsfImplWebMetaData.getContextParams());
            webMetaData.setContextParams(contextParams);
        }

        if (jsfImplWebMetaData.getListeners() != null)
        {
            List<ListenerMetaData> listeners = webMetaData.getListeners();
            if (listeners == null)
            {
                listeners = new ArrayList<ListenerMetaData>();
            }
            listeners.addAll(jsfImplWebMetaData.getListeners());
            webMetaData.setListeners(listeners);
        }
    }

    private Collection<JBossServletMetaData> makeJBossServletsMetaData(ServletsMetaData servletsMD)
    {
        Collection<JBossServletMetaData> servletSet = new HashSet<JBossServletMetaData>();
        for (ServletMetaData servletMD : servletsMD)
        {
            JBossServletMetaData jbossMD = new JBossServletMetaData();
            servletSet.add(jbossMD.merge(servletMD));
        }

        return servletSet;
    }
}