/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsf.deployer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.plugins.classloader.UrlIntegrationDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.jsf.deployer.JSFImplManagementDeployer;
import org.jboss.jsf.deployer.JSFImplMetaData;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFUrlIntegrationDeployer
extends UrlIntegrationDeployer<JSFImplMetaData> {
    private String jsfImplName;
    private JSFImplManagementDeployer implManager;
    private Collection<String> additionalURLs = new HashSet<String>(0);

    public JSFUrlIntegrationDeployer() {
        super(JSFImplMetaData.class);
        this.setDisableOptional(true);
    }

    public void setJSFImplName(String jsfImplName) {
        this.jsfImplName = jsfImplName;
    }

    public String getJSFImplName() {
        return this.jsfImplName;
    }

    public void setJSFImplManagementDeployer(JSFImplManagementDeployer implManager) {
        this.implManager = implManager;
    }

    public void setAdditionalURLs(Collection<String> additionalURLs) {
        this.additionalURLs = additionalURLs;
    }

    public void start() {
        JSFImplMetaData jsfImpl = this.implManager.getJSFImpl(this.jsfImplName);
        if (jsfImpl == null) {
            throw new IllegalStateException("JSF implementation " + this.jsfImplName + " not defined in JSFImplManagementDeployer.");
        }
        HashSet<URL> integrationURLs = new HashSet<URL>();
        integrationURLs.addAll(jsfImpl.getJars());
        for (String url : this.additionalURLs) {
            try {
                integrationURLs.add(new URL(StringPropertyReplacer.replaceProperties((String)url)));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("additionalURL " + url + " is invalid.", e);
            }
        }
        this.setIntegrationURLs(integrationURLs);
    }

    public void deploy(VFSDeploymentUnit unit, JSFImplMetaData jsfImpl) throws DeploymentException {
        if (!this.isIntegrationDeployment(unit, jsfImpl)) {
            return;
        }
        super.deploy(unit, (Object)jsfImpl);
        while (!unit.isTopLevel()) {
            unit = unit.getParent();
            super.deploy(unit, (Object)jsfImpl);
        }
    }

    public void undeploy(VFSDeploymentUnit unit, JSFImplMetaData jsfImpl) {
        if (!this.isIntegrationDeployment(unit, jsfImpl)) {
            return;
        }
        super.undeploy(unit, (Object)jsfImpl);
        while (!unit.isTopLevel()) {
            unit = unit.getParent();
            super.undeploy(unit, (Object)jsfImpl);
        }
    }

    protected boolean isIntegrationDeployment(VFSDeploymentUnit unit, JSFImplMetaData jsfImpl) {
        return jsfImpl.getImplName().equals(this.jsfImplName);
    }

    protected boolean isIntegrationDeployment(VFSDeploymentUnit unit) {
        return true;
    }
}

