/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.TestCase;
import org.jboss.jsfunit.analysis.ClassDefinitionsImpl;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.ManagedBeansImpl;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFacesConfigTestCase
extends TestCase {
    protected final Map<String, Document> documentsByPath = new HashMap<String, Document>();
    private StreamProvider streamProvider;

    public AbstractFacesConfigTestCase(Set<String> facesConfigPaths) {
        this(facesConfigPaths, new DefaultStreamProvider());
    }

    public AbstractFacesConfigTestCase(final String facesConfigPath) {
        this((Set<String>)new HashSet<String>(){
            {
                this.add(facesConfigPath);
            }
        });
    }

    AbstractFacesConfigTestCase(Set<String> facesConfigPaths, StreamProvider streamProvider) {
        if (streamProvider == null) {
            throw new IllegalArgumentException("stream provider is null");
        }
        if (facesConfigPaths == null || facesConfigPaths.isEmpty()) {
            throw new IllegalArgumentException("facesConfigPaths is null or empty");
        }
        this.streamProvider = streamProvider;
        this.parseResources(facesConfigPaths);
    }

    private void parseResources(Set<String> facesConfigPaths) {
        DocumentBuilder builder = ParserUtils.getDocumentBuilder();
        for (String facesConfigPath : facesConfigPaths) {
            String xml = ParserUtils.getXml(facesConfigPath, this.streamProvider);
            Document document = null;
            try {
                document = builder.parse(new ByteArrayInputStream(xml.getBytes()));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse document '" + facesConfigPath + "'\n" + xml, e);
            }
            this.documentsByPath.put(facesConfigPath, document);
        }
    }

    public void testClassDefinitions() {
        new ClassDefinitionsImpl(this.documentsByPath).test();
    }

    public void testManagedBeans() {
        new ManagedBeansImpl(this.documentsByPath).test();
    }
}

