/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContextFactory;
import javax.faces.convert.Converter;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import junit.framework.Assert;
import org.jboss.jsfunit.analysis.util.ClassUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassDefinitionsImpl {
    private final Map<String, Document> documentsByPath;
    private static final Map<String, Class[]> CLASS_CONSTRAINTS = new HashMap<String, Class[]>(){
        {
            this.put("action-listener", new Class[]{ActionListener.class});
            this.put("navigation-handler", new Class[]{NavigationHandler.class});
            this.put("variable-resolver", new Class[]{VariableResolver.class});
            this.put("property-resolver", new Class[]{PropertyResolver.class});
            this.put("view-handler", new Class[]{ViewHandler.class});
            this.put("state-manager", new Class[]{StateManager.class});
            this.put("faces-context-factory", new Class[]{FacesContextFactory.class});
            this.put("application-factory", new Class[]{ApplicationFactory.class});
            this.put("lifecycle-factory", new Class[]{LifecycleFactory.class});
            this.put("render-kit-factory", new Class[]{RenderKitFactory.class});
            this.put("component-class", new Class[]{UIComponent.class});
            this.put("converter-class", new Class[]{Converter.class});
            this.put("validator-class", new Class[]{Validator.class});
            this.put("managed-bean-class", new Class[0]);
            this.put("key-class", new Class[0]);
            this.put("value-class", new Class[0]);
            this.put("render-kit-class", new Class[]{RenderKit.class});
            this.put("renderer-class", new Class[]{Renderer.class});
            this.put("phase-listener", new Class[]{PhaseListener.class});
            this.put("converter-for-class", new Class[0]);
        }
    };

    public ClassDefinitionsImpl(Map<String, Document> documentsByPath) {
        this.documentsByPath = documentsByPath;
    }

    public void test() {
        for (String facesConfigPath : this.documentsByPath.keySet()) {
            this.classDefinitions(this.documentsByPath.get(facesConfigPath), facesConfigPath);
        }
    }

    private void classDefinitions(Node node, String faceConfigPath) {
        String nodeName = node.getNodeName();
        if (CLASS_CONSTRAINTS.keySet().contains(nodeName)) {
            String clazzName = node.getTextContent();
            clazzName = clazzName == null ? null : clazzName.trim();
            Class clazz = new ClassUtils().loadClass(clazzName, nodeName);
            Class[] constraints = CLASS_CONSTRAINTS.get(nodeName);
            if (constraints.length > 0 && !new ClassUtils().isAssignableFrom(constraints, clazz)) {
                Assert.fail((String)("In '" + faceConfigPath + "', " + clazz.getName() + " for element " + nodeName + " should be a " + new ClassUtils().getConstraintsList(constraints)));
            }
        } else {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.classDefinitions(children.item(i), faceConfigPath);
            }
        }
    }
}

