/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.jboss.jsfunit.analysis.util.ClassUtils;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManagedBeansImpl {
    private final Map<String, Document> documentsByPath;
    private static final List<String> SCOPES = new ArrayList<String>(){
        {
            this.add("none");
            this.add("request");
            this.add("session");
            this.add("application");
        }
    };

    public ManagedBeansImpl(Map<String, Document> documentsByPath) {
        this.documentsByPath = documentsByPath;
    }

    public void test() {
        HashMap<String, String> managedBeanNames = new HashMap<String, String>();
        String xpath = "//managed-bean";
        for (String facesConfigPath : this.documentsByPath.keySet()) {
            new ParserUtils();
            NodeList managedBeans = ParserUtils.query(this.documentsByPath.get(facesConfigPath), xpath, facesConfigPath);
            for (int i = 0; i < managedBeans.getLength(); ++i) {
                Node managedBean = managedBeans.item(i);
                this.doManagedBean(managedBean, facesConfigPath, managedBeanNames);
            }
        }
    }

    private void doManagedBean(Node parent, String facesConfigPath, Map<String, String> managedBeanNames) {
        new ParserUtils();
        String name = ParserUtils.querySingle(parent, "./managed-bean-name/text()", facesConfigPath);
        if (name == null || "".equals(name)) {
            throw new RuntimeException("could not determine name of " + parent.getNodeName() + " in " + facesConfigPath);
        }
        new ParserUtils();
        String clazz = ParserUtils.querySingle(parent, "./managed-bean-class/text()", facesConfigPath);
        if (clazz == null || "".equals(clazz)) {
            throw new RuntimeException("could not determine class of " + parent.getNodeName() + " '" + name + "' in " + facesConfigPath);
        }
        new ParserUtils();
        String scope = ParserUtils.querySingle(parent, "./managed-bean-scope/text()", facesConfigPath);
        if (scope == null || "".equals(scope)) {
            throw new RuntimeException("could not determine scope '" + scope + "' of " + parent.getNodeName() + " '" + name + "' in " + facesConfigPath);
        }
        this.failIfMapHasDuplicateKeys(parent, facesConfigPath, name);
        this.doManagedBean(facesConfigPath, parent.getChildNodes(), managedBeanNames, name, clazz, scope);
    }

    private void doManagedBean(String facesConfigPath, NodeList children, Map<String, String> managedBeanNames, String name, String clazz, String scope) {
        Class managedBeanClass;
        LinkedList<String> propertyNames = new LinkedList<String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"managed-property".equals(child.getNodeName())) continue;
            this.doManagedBeanProperty(child, propertyNames, name, facesConfigPath, clazz);
        }
        if (managedBeanNames.keySet().contains(name)) {
            Assert.fail((String)("The managed bean '" + name + "' in '" + facesConfigPath + "' is duplicated. Look for a managed bean w/ the same name in '" + managedBeanNames.get(name) + "'"));
        }
        managedBeanNames.put(name, facesConfigPath);
        if (!SCOPES.contains(scope)) {
            Assert.fail((String)("Managed bean '" + name + "' in " + facesConfigPath + " has an invalid scope '" + scope + "'"));
        }
        if (("session".equals(scope) || "application".equals(scope)) && !Serializable.class.isAssignableFrom(managedBeanClass = new ClassUtils().loadClass(clazz, "managed-bean-class"))) {
            Assert.fail((String)("Managed bean '" + name + "' is in " + scope + " scope, so it needs to implement " + Serializable.class));
        }
    }

    private void failIfMapHasDuplicateKeys(Node managedBean, String facesConfigPath, String name) {
        String query = "./managed-property/map-entries";
        String subQuery = "./map-entry/key";
        new ParserUtils();
        NodeList nodeList = ParserUtils.query(managedBean, query, facesConfigPath);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            new ParserUtils();
            NodeList keys = ParserUtils.query(nodeList.item(i), subQuery, facesConfigPath);
            HashSet<String> keyNames = new HashSet<String>();
            for (int j = 0; j < keys.getLength(); ++j) {
                Node firstChild = keys.item(j).getFirstChild();
                if (firstChild == null) continue;
                String textContent = firstChild.getTextContent();
                if (keyNames.contains(textContent)) {
                    Assert.fail((String)("Managed Bean '" + name + "' has a managed Map property w/ a duplicate key '" + textContent + "'"));
                }
                keyNames.add(textContent);
            }
        }
    }

    private void doManagedBeanProperty(Node parent, List<String> propertyNames, String managedBeanName, String facesConfig, String managedBeanClass) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"property-name".equals(child.getNodeName())) continue;
            String name = child.getTextContent();
            Class clazz = new ClassUtils().loadClass(managedBeanClass, "managed-bean-class");
            String setter = "set" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
            if (!this.hasMethod(setter, clazz)) {
                Assert.fail((String)("The managed bean '" + managedBeanName + "' has a managed property called '" + name + "', but " + clazz.getName() + " has no method " + setter + "(?)"));
            }
            if (propertyNames.contains(name)) {
                Assert.fail((String)("managed bean '" + managedBeanName + "' in " + facesConfig + " has a duplicate property named " + name));
            }
            propertyNames.add(name);
        }
    }

    private boolean hasMethod(String methodName, Class clazz) {
        if (clazz == null) {
            return false;
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!(methodName.equals(methods[i].getName()) & methods[i].getParameterTypes().length == 1)) continue;
            return true;
        }
        return this.hasMethod(methodName, clazz.getSuperclass());
    }
}

