/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.jboss.jsfunit.analysis.util.ClassUtils;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewConfigReconciler {
    private Map<String, List<String>> actionListeners;
    private Map<String, List<String>> actions;
    private Map<String, Document> configByPath;

    ViewConfigReconciler(Map<String, List<String>> actionListeners, Map<String, List<String>> actions, Map<String, Document> configByPath) {
        this.actionListeners = actionListeners;
        this.actions = actions;
        this.configByPath = configByPath;
    }

    void reconcileActions() {
        this.reconcileEL(this.actions);
    }

    void reconcileActionListeners() {
        this.reconcileEL(this.actionListeners);
    }

    private void reconcileEL(Map<String, List<String>> elByPath) {
        for (String path : elByPath.keySet()) {
            this.reconcileEl(path, elByPath.get(path));
        }
    }

    private void reconcileEl(String path, List<String> els) {
        for (String el : els) {
            if (!this.isEl(el)) continue;
            this.reconcile(path, el);
        }
    }

    private void reconcile(String path, String el) {
        String unwrapped = el.substring(2, el.length() - 1);
        int indexOfDot = unwrapped.indexOf(46);
        String beanName = unwrapped.substring(0, indexOfDot);
        String methodName = unwrapped.substring(indexOfDot + 1, unwrapped.length());
        String query = "//managed-bean-name[text()='" + beanName + "']";
        String subQuery = "./managed-bean-class";
        for (String configPath : this.configByPath.keySet()) {
            new ParserUtils();
            NodeList list = ParserUtils.query(this.configByPath.get(configPath), query, path);
            if (list.getLength() > 1) {
                Assert.fail((String)(path + " has two managed beans named '" + beanName + "'"));
                continue;
            }
            if (list.getLength() != 1) continue;
            Node managedBeanName = list.item(0);
            new ParserUtils();
            NodeList managedBeanClasses = ParserUtils.query(managedBeanName.getParentNode(), "./managed-bean-class", path);
            if (managedBeanClasses.getLength() == 0) {
                Assert.fail((String)(path + " has a managed-bean element w/out a managed-bean-class element"));
            } else if (managedBeanClasses.getLength() > 1) {
                Assert.fail((String)(path + " has a managed-bean element w/out > 1 managed-bean-class elements"));
            }
            this.verifyMethodExists(managedBeanClasses.item(0), methodName, path, beanName, el);
            return;
        }
        Assert.fail((String)(path + " has an EL expression '" + el + "' which references a" + " managed bean '" + beanName + "', but no managed bean by this name can be found."));
    }

    private void verifyMethodExists(Node managedBeanClassName, String methodName, String path, String beanName, String el) {
        Class managedBeanClass = new ClassUtils().loadClass(managedBeanClassName.getTextContent(), "managed-bean-class");
        for (Method method : managedBeanClass.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return;
        }
        Assert.fail((String)(path + " contains EL " + el + ", but managed bean " + beanName + "->" + managedBeanClass.getName() + " does not have a " + methodName + " method."));
    }

    private boolean isEl(String questionable) {
        return questionable != null && questionable.length() > 3 && questionable.charAt(0) == '#' && questionable.charAt(1) == '{' && questionable.charAt(questionable.length() - 1) == '}';
    }
}

