/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis.el;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.jsfunit.analysis.el.ELBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELExpressionIterator
implements Iterator<ELBundle> {
    private static final Pattern EL_EXPRESSION_PATTERN = Pattern.compile("(?:\\s(\\S+?)\\s*=)?\\s*[\"']?\\s*([#$]\\{(.*?)})", 8);
    private final File file;
    private ELBundle next;
    private final Matcher matcher;
    final Collection<Pattern> skipPatterns;

    private static CharBuffer fileAsCharBuffer(File f) throws IOException {
        FileChannel fc = new FileInputStream(f).getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        CharBuffer cb = Charset.forName("UTF-8").newDecoder().decode(bb);
        return cb;
    }

    public ELExpressionIterator(File file, Collection<Pattern> skipPatterns) throws IOException {
        this.file = file;
        this.skipPatterns = skipPatterns;
        this.matcher = EL_EXPRESSION_PATTERN.matcher(ELExpressionIterator.fileAsCharBuffer(file));
    }

    private ELBundle makeELBundle(MatchResult matchResult) {
        String expression;
        String context;
        switch (matchResult.groupCount()) {
            case 2: {
                context = "";
                expression = matchResult.group(1);
                break;
            }
            case 3: {
                context = matchResult.group(1);
                expression = matchResult.group(2);
                break;
            }
            default: {
                StringBuilder err = new StringBuilder("Unexpected match result:");
                for (int i = 0; i < matchResult.groupCount(); ++i) {
                    err.append(" " + i + ": " + matchResult.group(i));
                }
                throw new RuntimeException(err.toString());
            }
        }
        return new ELBundle(expression, this.file, context, matchResult.start());
    }

    @Override
    public boolean hasNext() {
        block0: while (this.next == null && this.matcher.find()) {
            for (Pattern p : this.skipPatterns) {
                if (!p.matcher(this.matcher.group()).find()) continue;
                continue block0;
            }
            this.next = this.makeELBundle(this.matcher.toMatchResult());
        }
        return this.next != null;
    }

    @Override
    public ELBundle next() {
        if (this.hasNext()) {
            ELBundle out = this.next;
            this.next = null;
            return out;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

