/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.jboss.jsfunit.analysis.JSFUnitEntityResolver;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.util.ResourceUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParserUtils {
    private static XPathFactory xPathFactory = XPathFactory.newInstance();
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new JSFUnitEntityResolver());
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Could not create a " + DocumentBuilder.class.getName());
        }
    }

    public static String getXml(String resourcePath, StreamProvider streamProvider) {
        InputStream stream = streamProvider.getInputStream(resourcePath);
        if (stream == null) {
            throw new RuntimeException("Could not locate file '" + resourcePath + "'");
        }
        return new ResourceUtils().getAsString(stream, resourcePath);
    }

    public static Document getDocument(String xml) throws SAXException, IOException {
        DocumentBuilder documentBuilder = ParserUtils.getDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(xml.getBytes()));
    }

    public static NodeList query(Node node, String xpathQuery, String filePath) {
        if (node == null) {
            throw new NullPointerException("document was null " + filePath);
        }
        XPath xpath = xPathFactory.newXPath();
        try {
            return (NodeList)xpath.evaluate(xpathQuery, node, XPathConstants.NODESET);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not run XPath query '" + xpathQuery + "' on document " + filePath);
        }
    }

    public static String querySingle(Node node, String xpathQuery, String filePath) {
        NodeList list = ParserUtils.query(node, xpathQuery, filePath);
        int count = list.getLength();
        if (count > 1) {
            throw new RuntimeException("query " + xpathQuery + " returned " + list.getLength() + " results. Should have been one.");
        }
        return count == 1 ? list.item(0).getTextContent() : null;
    }

    static {
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
    }
}

