/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.jsfunit.analysis.ApplicationTestSuite;
import org.jboss.jsfunit.analysis.ComponentTestCase;
import org.jboss.jsfunit.analysis.ConverterTestCase;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.FactoryTestSuite;
import org.jboss.jsfunit.analysis.LifecycleTestSuite;
import org.jboss.jsfunit.analysis.ManagedBeanTestSuite;
import org.jboss.jsfunit.analysis.NavigationRuleTestSuite;
import org.jboss.jsfunit.analysis.RenderKitTestSuite;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.ValidatorTestCase;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFileTestSuite
extends TestSuite {
    private StreamProvider streamProvider = null;

    public ConfigFileTestSuite(String name) {
        super(name);
    }

    public Test getSuite(String configFilePath, List<String> configFilePathList) {
        System.out.println("  start building dynamic suite for " + configFilePath);
        long timeStart = System.currentTimeMillis();
        TestSuite suite = new TestSuite();
        suite.setName(this.getName());
        if (configFilePath == null || "".equals(configFilePath.trim())) {
            return suite;
        }
        Document domDocument = this.getDomDocument(configFilePath);
        List<Node> applicationNodes = this.getApplicationNodes(domDocument, configFilePath);
        for (Node applicationNode : applicationNodes) {
            ApplicationTestSuite applicationSuite = new ApplicationTestSuite(this.getName() + "_application");
            applicationSuite.setStreamProvider(this.getStreamProvider());
            suite.addTest(applicationSuite.getSuite(configFilePath, applicationNode, configFilePathList));
        }
        List<Node> factoryNodes = this.getFactoryNodes(domDocument, configFilePath);
        for (Node factoryNode : factoryNodes) {
            FactoryTestSuite factorySuite = new FactoryTestSuite(this.getName() + "_factory");
            factorySuite.setStreamProvider(this.getStreamProvider());
            suite.addTest(factorySuite.getSuite(configFilePath, factoryNode, configFilePathList));
        }
        List<Node> componentNodes = this.getComponentNodes(domDocument, configFilePath);
        for (Node componentNode : componentNodes) {
            suite.addTest((Test)new ComponentTestCase(this.getName() + "_component", componentNode, configFilePath));
        }
        List<Node> converterNodes = this.getConverterNodes(domDocument, configFilePath);
        for (Node converterNode : converterNodes) {
            suite.addTest((Test)new ConverterTestCase(this.getName() + "_converter", converterNode, configFilePath));
        }
        Map<String, Node> beans = this.getManagedBeans(domDocument, configFilePath);
        for (String beanName : beans.keySet()) {
            ManagedBeanTestSuite beanSuite = new ManagedBeanTestSuite(beanName);
            beanSuite.setStreamProvider(this.getStreamProvider());
            suite.addTest(beanSuite.getSuite(configFilePath, beanName, beans.get(beanName)));
        }
        List<Node> navigationRuleNodes = this.getNavigationRuleNodes(domDocument, configFilePath);
        for (Node navigationRuleNode : navigationRuleNodes) {
            NavigationRuleTestSuite navigationRuleSuite = new NavigationRuleTestSuite(this.getName() + "_navigationRule");
            navigationRuleSuite.setStreamProvider(this.getStreamProvider());
            suite.addTest(navigationRuleSuite.getSuite(configFilePath, navigationRuleNode));
        }
        Map<String, Node> renderKits = this.getRenderKits(domDocument, configFilePath);
        for (String renderKitName : renderKits.keySet()) {
            RenderKitTestSuite renderKitSuite = new RenderKitTestSuite(renderKitName);
            renderKitSuite.setStreamProvider(this.getStreamProvider());
            suite.addTest(renderKitSuite.getSuite(configFilePath, renderKits.get(renderKitName)));
        }
        List<Node> lifecycleNodes = this.getLifecycleNodes(domDocument, configFilePath);
        for (Node lifecycleNode : lifecycleNodes) {
            LifecycleTestSuite lifecycleSuite = new LifecycleTestSuite(this.getName() + "_lifecycle");
            lifecycleSuite.setStreamProvider(this.getStreamProvider());
            suite.addTest(lifecycleSuite.getSuite(configFilePath, lifecycleNode));
        }
        List<Node> validatorNodes = this.getValidatorNodes(domDocument, configFilePath);
        for (Node validatorNode : validatorNodes) {
            suite.addTest((Test)new ValidatorTestCase(this.getName() + "_validator", validatorNode, configFilePath));
        }
        long timeStop = System.currentTimeMillis();
        double timeInSeconds = (double)(timeStop - timeStart) / 1000.0;
        System.out.println("  stop building dynamic suite (duration: " + timeInSeconds + " seconds) adding " + suite.countTestCases() + " testcases.");
        return suite;
    }

    private Map<String, Node> getManagedBeans(Document domDocument, String configFilePath) {
        HashMap<String, Node> beans = new HashMap<String, Node>();
        String xpathManagedBean = "/faces-config/managed-bean";
        String xpathManagedBeanName = "./managed-bean-name/text()";
        NodeList managedBeans = ParserUtils.query(domDocument, xpathManagedBean, configFilePath);
        for (int i = 0; i < managedBeans.getLength(); ++i) {
            Node bean = managedBeans.item(i);
            String name = ParserUtils.querySingle(bean, xpathManagedBeanName, configFilePath);
            if (name == null || name.trim().length() <= 0) continue;
            beans.put(name.trim(), bean);
        }
        return beans;
    }

    private List<Node> getApplicationNodes(Document domDocument, String configFilePath) {
        ArrayList<Node> result = new ArrayList<Node>();
        String xpathApplication = "/faces-config/application";
        NodeList applications = ParserUtils.query(domDocument, xpathApplication, configFilePath);
        for (int i = 0; i < applications.getLength(); ++i) {
            result.add(applications.item(i));
        }
        return result;
    }

    private List<Node> getFactoryNodes(Document domDocument, String configFilePath) {
        ArrayList<Node> result = new ArrayList<Node>();
        String xpathFactory = "/faces-config/factory";
        NodeList factories = ParserUtils.query(domDocument, xpathFactory, configFilePath);
        for (int i = 0; i < factories.getLength(); ++i) {
            result.add(factories.item(i));
        }
        return result;
    }

    private List<Node> getLifecycleNodes(Document domDocument, String configFilePath) {
        ArrayList<Node> result = new ArrayList<Node>();
        String xpathLifecycle = "/faces-config/lifecycle";
        NodeList lifecycles = ParserUtils.query(domDocument, xpathLifecycle, configFilePath);
        for (int i = 0; i < lifecycles.getLength(); ++i) {
            result.add(lifecycles.item(i));
        }
        return result;
    }

    private List<Node> getConverterNodes(Document domDocument, String configFilePath) {
        ArrayList<Node> result = new ArrayList<Node>();
        String xpathConverter = "/faces-config/converter";
        NodeList converters = ParserUtils.query(domDocument, xpathConverter, configFilePath);
        for (int i = 0; i < converters.getLength(); ++i) {
            result.add(converters.item(i));
        }
        return result;
    }

    private List<Node> getNavigationRuleNodes(Document domDocument, String configFilePath) {
        ArrayList<Node> result = new ArrayList<Node>();
        String xpathNavigationRule = "/faces-config/navigation-rule";
        NodeList navigationRules = ParserUtils.query(domDocument, xpathNavigationRule, configFilePath);
        for (int i = 0; i < navigationRules.getLength(); ++i) {
            result.add(navigationRules.item(i));
        }
        return result;
    }

    private List<Node> getValidatorNodes(Document domDocument, String configFilePath) {
        ArrayList<Node> result = new ArrayList<Node>();
        String xpathValidator = "/faces-config/validator";
        NodeList validators = ParserUtils.query(domDocument, xpathValidator, configFilePath);
        for (int i = 0; i < validators.getLength(); ++i) {
            result.add(validators.item(i));
        }
        return result;
    }

    private List<Node> getComponentNodes(Document domDocument, String configFilePath) {
        ArrayList<Node> result = new ArrayList<Node>();
        String xpathComponent = "/faces-config/component";
        NodeList components = ParserUtils.query(domDocument, xpathComponent, configFilePath);
        for (int i = 0; i < components.getLength(); ++i) {
            result.add(components.item(i));
        }
        return result;
    }

    private Map<String, Node> getRenderKits(Document domDocument, String configFilePath) {
        HashMap<String, Node> result = new HashMap<String, Node>();
        String xpathRenderKit = "/faces-config/render-kit";
        String xpathRenderKitId = "./render-kit-id/text()";
        NodeList renderKits = ParserUtils.query(domDocument, xpathRenderKit, configFilePath);
        for (int i = 0; i < renderKits.getLength(); ++i) {
            Node renderKit = renderKits.item(i);
            String renderKitId = ParserUtils.querySingle(renderKit, xpathRenderKitId, configFilePath);
            renderKitId = renderKitId == null || renderKitId.trim().length() == 0 ? "default" : renderKitId.trim();
            result.put(renderKitId, renderKit);
        }
        return result;
    }

    private Document getDomDocument(String filePath) {
        String xml = ParserUtils.getXml(filePath, this.getStreamProvider());
        DocumentBuilder builder = ParserUtils.getDocumentBuilder();
        Document document = null;
        try {
            document = builder.parse(new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse document '" + filePath + "'\n" + xml, e);
        }
        return document;
    }

    public StreamProvider getStreamProvider() {
        if (this.streamProvider == null) {
            this.streamProvider = new DefaultStreamProvider();
        }
        return this.streamProvider;
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }
}

