/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.List;
import junit.framework.TestCase;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.util.ConfigUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRenderkitTestCase
extends TestCase {
    protected String defaultRenderkitId = null;
    protected List<String> configFilePathList = null;
    private StreamProvider streamProvider = null;
    private ConfigUtils configUtils = null;

    public DefaultRenderkitTestCase(String defaultRenderkitId, List<String> configFilePathList) {
        super("defaultRenderkit");
        this.defaultRenderkitId = defaultRenderkitId;
        this.configFilePathList = configFilePathList;
        this.getConfigUtils().setConfigFilePaths(configFilePathList);
    }

    public DefaultRenderkitTestCase(String defaultRenderkitId, List<String> configFilePathList, ConfigUtils configUtils) {
        super("defaultRenderkit");
        this.defaultRenderkitId = defaultRenderkitId;
        this.configFilePathList = configFilePathList;
        this.setConfigUtils(configUtils);
    }

    public void runTest() {
        this.testRenderkitDefined();
    }

    public void testRenderkitDefined() {
        this.configUtils.setStreamProvider(this.getStreamProvider());
        DefaultRenderkitTestCase.assertTrue((String)("Default renderkit '" + this.defaultRenderkitId + "' is not defined in the config files."), (boolean)this.configUtils.isConfigured(ConfigUtils.ConfigItemType.RENDER_KIT, this.defaultRenderkitId, true));
    }

    public StreamProvider getStreamProvider() {
        if (this.streamProvider == null) {
            this.streamProvider = new DefaultStreamProvider();
        }
        return this.streamProvider;
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    public ConfigUtils getConfigUtils() {
        if (this.configUtils == null) {
            this.configUtils = new ConfigUtils();
            this.configUtils.setConfigFilePaths(this.configFilePathList);
        }
        return this.configUtils;
    }

    public void setConfigUtils(ConfigUtils configUtils) {
        this.configUtils = configUtils;
    }
}

