/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.jsfunit.analysis.ApplicationFactoryTestCase;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.FacesContextFactoryTestCase;
import org.jboss.jsfunit.analysis.LifecycleFactoryTestCase;
import org.jboss.jsfunit.analysis.RenderKitFactoryTestCase;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryTestSuite
extends TestSuite
implements Test {
    private StreamProvider streamProvider = null;

    public FactoryTestSuite(String name) {
        super(name);
    }

    public Test getSuite(String configFilePath, Node factoryNode, List<String> configFilePathList) {
        String renderKitFactory;
        String lifecycleFactory;
        String facesContextFactory;
        TestSuite suite = new TestSuite();
        suite.setName(this.getName());
        if (configFilePath == null || "".equals(configFilePath.trim()) || factoryNode == null) {
            return suite;
        }
        String applicationFactory = this.getApplicationFactory(factoryNode, configFilePath);
        if (applicationFactory != null) {
            suite.addTest((Test)new ApplicationFactoryTestCase(applicationFactory, applicationFactory));
        }
        if ((facesContextFactory = this.getFacesContextFactory(factoryNode, configFilePath)) != null) {
            suite.addTest((Test)new FacesContextFactoryTestCase(facesContextFactory, facesContextFactory));
        }
        if ((lifecycleFactory = this.getLifecycleFactory(factoryNode, configFilePath)) != null) {
            suite.addTest((Test)new LifecycleFactoryTestCase(lifecycleFactory, lifecycleFactory));
        }
        if ((renderKitFactory = this.getRenderKitFactory(factoryNode, configFilePath)) != null) {
            suite.addTest((Test)new RenderKitFactoryTestCase(renderKitFactory, renderKitFactory));
        }
        return suite;
    }

    private String getApplicationFactory(Node factoryNode, String configFilePath) {
        String result = null;
        String xpathApplicationFactory = "./application-factory";
        String xpathApplicationFactoryClassName = "./text()";
        NodeList applicationFactories = ParserUtils.query(factoryNode, xpathApplicationFactory, configFilePath);
        switch (applicationFactories.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Node applicationFactory = applicationFactories.item(0);
                String name = ParserUtils.querySingle(applicationFactory, xpathApplicationFactoryClassName, configFilePath);
                if (name != null && name.trim().length() > 0) {
                    result = name.trim();
                    break;
                }
                result = "";
                break;
            }
            default: {
                throw new RuntimeException("only one application factory node may be specified in an factory node");
            }
        }
        return result;
    }

    private String getFacesContextFactory(Node factoryNode, String configFilePath) {
        String result = null;
        String xpathFacesContextFactory = "./faces-context-factory";
        String xpathFacesContextFactoryClassName = "./text()";
        NodeList facesContextFactories = ParserUtils.query(factoryNode, xpathFacesContextFactory, configFilePath);
        switch (facesContextFactories.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Node facesContextFactory = facesContextFactories.item(0);
                String name = ParserUtils.querySingle(facesContextFactory, xpathFacesContextFactoryClassName, configFilePath);
                if (name != null && name.trim().length() > 0) {
                    result = name.trim();
                    break;
                }
                result = "";
                break;
            }
            default: {
                throw new RuntimeException("only one faces context factory node may be specified in an factory node");
            }
        }
        return result;
    }

    private String getRenderKitFactory(Node factoryNode, String configFilePath) {
        String result = null;
        String xpathRenderKitFactory = "./render-kit-factory";
        String xpathRenderKitFactoryClassName = "./text()";
        NodeList renderKitFactories = ParserUtils.query(factoryNode, xpathRenderKitFactory, configFilePath);
        switch (renderKitFactories.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Node renderKitFactory = renderKitFactories.item(0);
                String name = ParserUtils.querySingle(renderKitFactory, xpathRenderKitFactoryClassName, configFilePath);
                if (name != null && name.trim().length() > 0) {
                    result = name.trim();
                    break;
                }
                result = "";
                break;
            }
            default: {
                throw new RuntimeException("only one render kit factory node may be specified in an factory node");
            }
        }
        return result;
    }

    private String getLifecycleFactory(Node factoryNode, String configFilePath) {
        String result = null;
        String xpathLifecycleFactory = "./lifecycle-factory";
        String xpathLifecycleFactoryClassName = "./text()";
        NodeList lifecycleFactories = ParserUtils.query(factoryNode, xpathLifecycleFactory, configFilePath);
        switch (lifecycleFactories.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Node lifecycleFactory = lifecycleFactories.item(0);
                String name = ParserUtils.querySingle(lifecycleFactory, xpathLifecycleFactoryClassName, configFilePath);
                if (name != null && name.trim().length() > 0) {
                    result = name.trim();
                    break;
                }
                result = "";
                break;
            }
            default: {
                throw new RuntimeException("only one lifecycle factory node may be specified in an factory node");
            }
        }
        return result;
    }

    public StreamProvider getStreamProvider() {
        if (this.streamProvider == null) {
            this.streamProvider = new DefaultStreamProvider();
        }
        return this.streamProvider;
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }
}

