/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.LifecycleTestCase;
import org.jboss.jsfunit.analysis.PhaseListenerTestCase;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleTestSuite
extends TestSuite
implements Test {
    private StreamProvider streamProvider = null;

    public LifecycleTestSuite(String name) {
        super(name);
    }

    public Test getSuite(String configFilePath, Node lifecycleNode) {
        TestSuite suite = new TestSuite();
        suite.setName(this.getName());
        suite.addTest((Test)new LifecycleTestCase(this.getName(), configFilePath, lifecycleNode));
        if (configFilePath == null || "".equals(configFilePath.trim()) || lifecycleNode == null) {
            return suite;
        }
        List<String> phaseListeners = this.getPhaseListeners(lifecycleNode, configFilePath);
        for (String phaseListener : phaseListeners) {
            suite.addTest((Test)new PhaseListenerTestCase(phaseListener, phaseListener));
        }
        return suite;
    }

    private List<String> getPhaseListeners(Node lifecycleNode, String configFilePath) {
        ArrayList<String> result = new ArrayList<String>();
        String xpathPhaseListener = "./phase-listener";
        String xpathPhaseListenerClassName = "./text()";
        NodeList phaseListeners = ParserUtils.query(lifecycleNode, xpathPhaseListener, configFilePath);
        for (int i = 0; i < phaseListeners.getLength(); ++i) {
            Node phaseListener = phaseListeners.item(i);
            String name = ParserUtils.querySingle(phaseListener, xpathPhaseListenerClassName, configFilePath);
            if (name == null || name.trim().length() <= 0) continue;
            result.add(name.trim());
        }
        return result;
    }

    public StreamProvider getStreamProvider() {
        if (this.streamProvider == null) {
            this.streamProvider = new DefaultStreamProvider();
        }
        return this.streamProvider;
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }
}

