/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.ManagedBeanTestCase;
import org.jboss.jsfunit.analysis.ManagedPropertyTestCase;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBeanTestSuite
extends TestSuite
implements Test {
    private StreamProvider streamProvider = null;

    public ManagedBeanTestSuite(String name) {
        super(name);
    }

    public Test getSuite(String configFilePath, String managedBeanName, Node managedBeanNode) {
        TestSuite suite = new TestSuite();
        suite.setName(this.getName());
        suite.addTest((Test)new ManagedBeanTestCase(managedBeanName, configFilePath, managedBeanName, managedBeanNode));
        Map<String, Node> properties = this.getManagedProperties(configFilePath, managedBeanName, managedBeanNode);
        String managedBeanClassName = this.getManagedBeanClassName(configFilePath, managedBeanNode);
        for (String property : properties.keySet()) {
            suite.addTest((Test)new ManagedPropertyTestCase(property, configFilePath, managedBeanName, managedBeanClassName, property, properties.get(property)));
        }
        return suite;
    }

    private Map<String, Node> getManagedProperties(String configFilePath, String managedBeanName, Node managedBeanNode) {
        HashMap<String, Node> properties = new HashMap<String, Node>();
        String xpath = "/faces-config/managed-bean";
        String xpathBeanName = "./managed-bean-name/text()";
        String xpathProperty = "./managed-property";
        String xpathPropertyName = "./property-name/text()";
        NodeList managedBeans = ParserUtils.query(managedBeanNode, xpath, configFilePath);
        for (int i = 0; i < managedBeans.getLength(); ++i) {
            Node bean = managedBeans.item(i);
            String name = ParserUtils.querySingle(bean, xpathBeanName, configFilePath);
            if (name == null || name.trim().length() <= 0 || !managedBeanName.equals(name)) continue;
            NodeList managedProperties = ParserUtils.query(bean, xpathProperty, configFilePath);
            for (int j = 0; j < managedProperties.getLength(); ++j) {
                Node property = managedProperties.item(j);
                String propertyName = ParserUtils.querySingle(property, xpathPropertyName, configFilePath).trim();
                if (propertyName == null || propertyName.trim().length() <= 0) continue;
                properties.put(propertyName, property);
            }
        }
        return properties;
    }

    private String getManagedBeanClassName(String configFilePath, Node managedBeanNode) {
        String xpath = "./managed-bean-class/text()";
        return ParserUtils.querySingle(managedBeanNode, xpath, configFilePath).trim();
    }

    public StreamProvider getStreamProvider() {
        if (this.streamProvider == null) {
            this.streamProvider = new DefaultStreamProvider();
        }
        return this.streamProvider;
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }
}

