/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import junit.framework.TestCase;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;

public class NavigationCaseTestCase
extends TestCase {
    protected String configFilePath = null;
    protected Node navigationCaseNode;

    public NavigationCaseTestCase(String name, String configFilePath, Node navigationCaseNode) {
        super(name);
        this.configFilePath = configFilePath;
        this.navigationCaseNode = navigationCaseNode;
    }

    public void runTest() {
        this.testToViewId();
        this.testRedirectNoDuplicates();
        this.testFromAction();
    }

    public void testToViewId() {
        try {
            NavigationCaseTestCase.assertTrue((String)"'to-view-id' must be configured for a 'navigation-case'", (boolean)this.isSingleValueConfigured(this.getToViewId()));
        }
        catch (RuntimeException re) {
            NavigationCaseTestCase.assertTrue((String)re.getMessage(), (boolean)re.getMessage().startsWith("query ./to-view-id/text() returned"));
            NavigationCaseTestCase.fail((String)"'to-view-id' must not be configured more than once for a 'navigation-case'");
        }
    }

    public void testFromAction() {
        try {
            String fromAction = this.getFromAction();
            if (fromAction != null && fromAction.trim().length() == 0) {
                NavigationCaseTestCase.fail((String)"'from-action' must not be configured with empty content");
            }
        }
        catch (RuntimeException re) {
            NavigationCaseTestCase.assertTrue((String)re.getMessage(), (boolean)re.getMessage().startsWith("query ./from-action/text() returned"));
            NavigationCaseTestCase.fail((String)"'from-action' must not be configured more than once for a 'navigation-case'");
        }
    }

    public void testRedirectNoDuplicates() {
        try {
            this.getRedirect();
        }
        catch (RuntimeException re) {
            NavigationCaseTestCase.assertTrue((String)re.getMessage(), (boolean)re.getMessage().startsWith("query ./redirect returned"));
            NavigationCaseTestCase.fail((String)"'redirect' must not be configured more than once for a 'navigation-case'");
        }
    }

    private boolean isSingleValueConfigured(String value) {
        boolean result = false;
        if (value != null && value.trim().length() > 0) {
            result = true;
        }
        return result;
    }

    private String getFromAction() {
        String xpath = "./from-action/text()";
        String fromAction = ParserUtils.querySingle(this.navigationCaseNode, xpath, this.configFilePath);
        return fromAction;
    }

    private String getToViewId() {
        String xpath = "./to-view-id/text()";
        String toViewId = ParserUtils.querySingle(this.navigationCaseNode, xpath, this.configFilePath);
        return toViewId;
    }

    private String getRedirect() {
        String xpath = "./redirect";
        String redirect = ParserUtils.querySingle(this.navigationCaseNode, xpath, this.configFilePath);
        return redirect;
    }
}

