/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.RenderKitTestCase;
import org.jboss.jsfunit.analysis.RendererTestCase;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitTestSuite
extends TestSuite
implements Test {
    private StreamProvider streamProvider = null;

    public RenderKitTestSuite(String name) {
        super(name);
    }

    public Test getSuite(String configFilePath, Node renderKitNode) {
        TestSuite suite = new TestSuite();
        suite.setName(this.getName());
        suite.addTest((Test)new RenderKitTestCase(this.getName(), configFilePath, renderKitNode));
        if (configFilePath == null || "".equals(configFilePath.trim()) || renderKitNode == null) {
            return suite;
        }
        Map<String, Node> renderers = this.getRenderers(configFilePath, renderKitNode);
        for (String rendererName : renderers.keySet()) {
            suite.addTest((Test)new RendererTestCase(rendererName, renderers.get(rendererName), configFilePath));
        }
        return suite;
    }

    private Map<String, Node> getRenderers(String configFilePath, Node renderKitNode) {
        HashMap<String, Node> rendererNodes = new HashMap<String, Node>();
        String xpathRenderer = "./renderer";
        String xpathRendererDisplayName = "./display-name/text()";
        String xpathRendererClassName = "./renderer-class/text()";
        NodeList renderers = ParserUtils.query(renderKitNode, xpathRenderer, configFilePath);
        for (int i = 0; i < renderers.getLength(); ++i) {
            String className;
            Node renderer = renderers.item(i);
            String rendererName = null;
            String displayName = ParserUtils.querySingle(renderer, xpathRendererDisplayName, configFilePath);
            rendererName = displayName != null && displayName.trim().length() > 0 ? displayName.trim() : ((className = ParserUtils.querySingle(renderer, xpathRendererClassName, configFilePath)) != null ? className.trim() : "unknown");
            rendererNodes.put(rendererName, renderer);
        }
        return rendererNodes;
    }

    public StreamProvider getStreamProvider() {
        if (this.streamProvider == null) {
            this.streamProvider = new DefaultStreamProvider();
        }
        return this.streamProvider;
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }
}

