/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis.el;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.collection.CompositeCollection;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jboss.jsfunit.analysis.el.ELBundle;
import org.jboss.jsfunit.analysis.el.ELExpressionIterator;
import org.jboss.jsfunit.analysis.el.ELIterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFileELExpressionIterator
implements Iterator<ELBundle> {
    private final Iterator<File> fileIter;
    private Iterator<ELBundle> currIter = ELIterFactory.EMPTY_ITER;
    private final Collection<Pattern> alwaysSkipPatterns;
    private final Map<IOFileFilter, Pattern> sometimesSkipPatterns;
    private final ArrayList<Pattern> skipBuffer;

    private static <T> Collection<T> unmodifiableComposite(Collection<T> coll1, Collection<T> coll2) {
        CompositeCollection compColl = new CompositeCollection();
        compColl.addComposited(coll1, coll2);
        return Collections.unmodifiableCollection(compColl);
    }

    public MultiFileELExpressionIterator(Iterator<File> fileIter, Collection<Pattern> alwaysSkipPatterns, Map<IOFileFilter, Pattern> sometimesSkipPatterns) {
        this.fileIter = fileIter;
        this.alwaysSkipPatterns = alwaysSkipPatterns;
        this.sometimesSkipPatterns = sometimesSkipPatterns;
        int buffersz = sometimesSkipPatterns.size();
        this.skipBuffer = new ArrayList(buffersz);
    }

    private Collection<Pattern> getSkipPatterns(File file) {
        this.skipBuffer.clear();
        for (Map.Entry<IOFileFilter, Pattern> e : this.sometimesSkipPatterns.entrySet()) {
            IOFileFilter filter = e.getKey();
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            this.skipBuffer.add(e.getValue());
        }
        return MultiFileELExpressionIterator.unmodifiableComposite(this.alwaysSkipPatterns, this.skipBuffer);
    }

    @Override
    public boolean hasNext() {
        while (!this.currIter.hasNext() && this.fileIter.hasNext()) {
            try {
                File file = this.fileIter.next();
                this.currIter = new ELExpressionIterator(file, this.getSkipPatterns(file));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.currIter.hasNext();
    }

    @Override
    public ELBundle next() {
        this.hasNext();
        return this.currIter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

