/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis.util;

import junit.framework.Assert;

public class ClassUtils {
    public boolean isAssignableFrom(Class[] constraints, Class clazz) {
        for (Class constraint : constraints) {
            if (!constraint.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public Class loadClass(String clazzName, String elementName) {
        if (clazzName == null) {
            throw new RuntimeException("No class for element '" + elementName + "' (classname null)");
        }
        try {
            return this.getClass().getClassLoader().loadClass(clazzName.trim());
        }
        catch (ClassNotFoundException e) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(clazzName.trim());
            }
            catch (ClassNotFoundException e2) {
                Assert.fail((String)("Could not load class '" + clazzName + "' for element '" + elementName + "'"));
                return null;
            }
            catch (NoClassDefFoundError ncdf2) {
                Assert.fail((String)("Could not load class '" + clazzName + "' for element '" + elementName + "' because of NoClassDefFoundError (" + ncdf2.getMessage() + ")"));
                return null;
            }
        }
        catch (NoClassDefFoundError ncdf) {
            Assert.fail((String)("Could not load class '" + clazzName + "' for element '" + elementName + "' because of NoClassDefFoundError (" + ncdf.getMessage() + ")"));
            return null;
        }
    }

    public String getConstraintsList(Class[] constraints) {
        String msg = "";
        for (int c = 0; c < constraints.length; ++c) {
            msg = msg + constraints[c].getName() + (c == constraints.length - 1 ? "" : " or ");
        }
        return msg;
    }
}

