/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static List<String> findFilesRecursive(String rootPath, List<String> allowedExtensions) {
        File rootFolder = new File(rootPath);
        return FileUtils.findFilesRecursive(rootFolder, allowedExtensions);
    }

    public static List<String> findFilesRecursive(File rootFolder, List<String> allowedExtensions) {
        List<String> foundFiles = FileUtils.findFiles(rootFolder, allowedExtensions);
        File[] subFolders = rootFolder.listFiles(new FolderFilter());
        for (int i = 0; i < subFolders.length; ++i) {
            foundFiles.addAll(FileUtils.findFilesRecursive(subFolders[i], allowedExtensions));
        }
        return foundFiles;
    }

    public static List<String> findFiles(String folderPath, List<String> allowedExtensions) {
        File folder = new File(folderPath);
        return FileUtils.findFiles(folder, allowedExtensions);
    }

    public static List<String> findFiles(File folder, List<String> allowedExtensions) {
        String folderPath;
        if (folder == null) {
            throw new IllegalArgumentException("Folder must not be null");
        }
        try {
            folderPath = folder.getCanonicalPath() + File.separator;
        }
        catch (IOException e) {
            folderPath = "---exception: " + e.getLocalizedMessage() + File.separator;
        }
        ArrayList<String> foundFiles = new ArrayList<String>();
        FileExtensionFilter filter = new FileExtensionFilter(allowedExtensions);
        String[] files = folder.list(filter);
        for (int i = 0; i < files.length; ++i) {
            foundFiles.add(folderPath + files[i]);
        }
        return foundFiles;
    }

    public static String extractExtension(String fileName) {
        int place;
        String extension = null;
        extension = fileName == null ? "" : ((place = fileName.lastIndexOf(46)) >= 0 ? fileName.substring(place + 1) : "");
        return extension;
    }

    public static class FolderFilter
    implements FileFilter {
        public boolean accept(File inFile) {
            if (inFile != null) {
                return inFile.isDirectory();
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileExtensionFilter
    implements FilenameFilter {
        private List<String> allowedExtensions;

        public FileExtensionFilter() {
            this.allowedExtensions = null;
        }

        public FileExtensionFilter(List<String> allowedExtensions) {
            this.allowedExtensions = allowedExtensions;
        }

        public List<String> getAllowedExtensions() {
            return this.allowedExtensions;
        }

        public void setAllowedExtensions(List<String> allowedExtensions) {
            this.allowedExtensions = allowedExtensions;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.allowedExtensions == null || this.allowedExtensions.isEmpty()) {
                return true;
            }
            String extension = FileUtils.extractExtension(name);
            return this.allowedExtensions.contains(extension);
        }
    }
}

