/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    public static List<InputStream> getClassPathResourcesAsStreams(String relativeResourceName) {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        try {
            Enumeration<URL> resourceUrls = Thread.currentThread().getContextClassLoader().getResources(relativeResourceName);
            while (resourceUrls.hasMoreElements()) {
                result.add((InputStream)resourceUrls.nextElement().getContent());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        return result;
    }

    public String getAsString(InputStream stream, String resourceName) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuffer buffer = new StringBuffer();
        String temp = null;
        try {
            while ((temp = reader.readLine()) != null) {
                buffer.append(temp);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read file " + resourceName, e);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close stream for " + resourceName);
        }
        return buffer.toString();
    }
}

