/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.jsfsession.hellojsf;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.cactus.ServletTestCase;
import org.jboss.jsfunit.framework.Environment;
import org.jboss.jsfunit.framework.WebClientSpec;
import org.jboss.jsfunit.jsfsession.ComponentIDNotFoundException;
import org.jboss.jsfunit.jsfsession.JSFClientSession;
import org.jboss.jsfunit.jsfsession.JSFServerSession;
import org.jboss.jsfunit.jsfsession.JSFSession;

/*
 * Exception performing whole class analysis ignored.
 */
public class FacadeAPITest
extends ServletTestCase {
    private JSFClientSession client;
    private JSFServerSession server;

    public void setUp() throws IOException {
        JSFSession jsfSession = new JSFSession("/index.faces");
        this.client = jsfSession.getJSFClientSession();
        this.server = jsfSession.getJSFServerSession();
    }

    public static Test suite() {
        return new TestSuite(FacadeAPITest.class);
    }

    public void testCustomBrowserVersion() throws IOException {
        WebClientSpec wcSpec = new WebClientSpec("/index.faces", BrowserVersion.INTERNET_EXPLORER_7);
        JSFSession jsfSession = new JSFSession(wcSpec);
        FacadeAPITest.assertEquals((Object)BrowserVersion.INTERNET_EXPLORER_7, (Object)jsfSession.getWebClient().getBrowserVersion());
    }

    public void testGetCurrentViewId() throws IOException {
        FacadeAPITest.assertEquals((String)"/index.jsp", (String)this.server.getCurrentViewID());
        FacadeAPITest.assertEquals((String)this.server.getCurrentViewID(), (String)this.server.getFacesContext().getViewRoot().getViewId());
    }

    public void testSetParamAndSubmit() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("submit_button");
        UIComponent greeting = this.server.findComponent("greeting");
        FacadeAPITest.assertTrue((boolean)greeting.isRendered());
    }

    public void testSetCheckbox() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("funcheck");
        this.client.click("submit_button");
        FacadeAPITest.assertFalse((boolean)((Boolean)this.server.getManagedBeanValue("#{checkbox.funCheck}")));
        this.client.click("funcheck");
        this.client.click("submit_button");
        FacadeAPITest.assertTrue((boolean)((Boolean)this.server.getManagedBeanValue("#{checkbox.funCheck}")));
    }

    public void testClickCommandLink() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("goodbye_button");
        this.client.click("go_back_link");
        FacadeAPITest.assertEquals((String)"/index.jsp", (String)this.server.getCurrentViewID());
    }

    public void testCommandLinkWithoutViewChange() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("goodbye_button");
        this.client.click("stay_here_link");
        FacadeAPITest.assertEquals((String)"/finalgreeting.jsp", (String)this.server.getCurrentViewID());
    }

    public void testCommandLinkWithFParam() throws IOException {
        this.client.setValue("input_foo_text", "Stan");
        this.client.click("goodbye_button");
        this.client.click("stay_here_link");
        String name = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("name");
        FacadeAPITest.assertEquals((String)"Stan", (String)name);
    }

    public void testCommandLinkWithParamFromLoopVariable() throws IOException {
        if (Environment.getJSFMajorVersion() == 1 && Environment.getJSFMinorVersion() < 2) {
            return;
        }
        JSFSession jsfSession = new JSFSession("/marathons.faces");
        JSFClientSession client = jsfSession.getJSFClientSession();
        client.click("marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: BAA Boston Marathon"));
        client.click("marathonSelectj_id_3");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: Flora London Marathon"));
        client.click("marathonSelectj_id_5");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: Olympic Marathon"));
    }

    public void testCommandLinkWithParamFromDatatableVariable() throws IOException {
        JSFSession jsfSession = new JSFSession("/marathons_datatable.faces");
        JSFClientSession client = jsfSession.getJSFClientSession();
        client.click("0:marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: BAA Boston Marathon"));
        client.click("3:marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: Flora London Marathon"));
        client.click("5:marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: Olympic Marathon"));
    }

    public void testInvalidateSession() throws IOException {
        JSFSession jsfSession = new JSFSession("/marathons_datatable.faces");
        JSFClientSession client = jsfSession.getJSFClientSession();
        JSFServerSession server = jsfSession.getJSFServerSession();
        client.click("0:marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: BAA Boston Marathon"));
        FacadeAPITest.assertEquals((Object)"BAA Boston Marathon", (Object)server.getManagedBeanValue("#{marathons.selectedMarathon}"));
        client.click("invalidateSession");
        client.click("0:marathonSelect");
        FacadeAPITest.assertTrue((boolean)client.getPageAsText().contains("Selected Marathon: BAA Boston Marathon"));
        FacadeAPITest.assertEquals((Object)"BAA Boston Marathon", (Object)server.getManagedBeanValue("#{marathons.selectedMarathon}"));
    }

    public void testServerSideComponentValue() throws IOException {
        this.testSetParamAndSubmit();
        FacadeAPITest.assertEquals((Object)"Hello Stan", (Object)this.server.getComponentValue("greeting"));
    }

    public void testManagedBeanValue() throws IOException {
        this.testSetParamAndSubmit();
        FacadeAPITest.assertEquals((Object)"Stan", (Object)this.server.getManagedBeanValue("#{foo.text}"));
    }

    public void testFacesMessages() throws IOException {
        this.client.setValue("input_foo_text", "A");
        this.client.click("submit_button");
        FacadeAPITest.assertEquals((String)"/index.jsp", (String)this.server.getCurrentViewID());
        Iterator allMessages = this.server.getFacesMessages();
        allMessages.next();
        FacadeAPITest.assertFalse((boolean)allMessages.hasNext());
        Iterator checkboxMessages = this.server.getFacesMessages("funcheck");
        FacadeAPITest.assertFalse((boolean)checkboxMessages.hasNext());
        Iterator fooTextMessages = this.server.getFacesMessages("input_foo_text");
        FacesMessage message = (FacesMessage)fooTextMessages.next();
        FacadeAPITest.assertTrue((boolean)message.getDetail().contains("input_foo_text"));
    }

    public void testClickThrowsComponentNotFound() throws IOException {
        try {
            this.client.click("thiselementisnotthere");
            FacadeAPITest.fail((String)"Expected ComponentIDNotFoundException");
        }
        catch (ComponentIDNotFoundException componentIDNotFoundException) {
            // empty catch block
        }
    }

    public void testSetValueThrowsComponentNotFound() throws IOException {
        try {
            this.client.setValue("thiselementisnotthere", "bogusvalue");
            FacadeAPITest.fail((String)"Expected ComponentIDNotFoundException");
        }
        catch (ComponentIDNotFoundException componentIDNotFoundException) {
            // empty catch block
        }
    }

    public void testTypeThrowsComponentNotFound() throws IOException {
        try {
            this.client.type("thiselementisnotthere", 'b');
            FacadeAPITest.fail((String)"Expected ComponentIDNotFoundException");
        }
        catch (ComponentIDNotFoundException componentIDNotFoundException) {
            // empty catch block
        }
    }
}

