/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.StyledElement;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClickableElement
extends StyledElement {
    private static final long serialVersionUID = 5708324473968728785L;
    private final transient Log mainLog_ = LogFactory.getLog(this.getClass());

    protected ClickableElement(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public <P extends Page> P click() throws IOException {
        return this.click(false, false, false);
    }

    public <P extends Page> P click(boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)this.getPage();
        }
        this.mouseDown(shiftKey, ctrlKey, altKey, 0);
        if (this instanceof SubmittableElement) {
            ((HtmlPage)this.getPage()).setFocusedElement(this);
        }
        this.mouseUp(shiftKey, ctrlKey, altKey, 0);
        MouseEvent event = new MouseEvent((DomNode)this, "click", shiftKey, ctrlKey, altKey, 0);
        return this.click(event);
    }

    public <P extends Page> P click(Event event) throws IOException {
        ScriptResult scriptResult;
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)this.getPage();
        }
        SgmlPage page = this.getPage();
        boolean stateUpdated = false;
        if (this.isStateUpdateFirst()) {
            this.doClickAction(page);
            stateUpdated = true;
        }
        Page currentPage = (scriptResult = this.fireEvent(event)) == null ? page : scriptResult.getNewPage();
        if (stateUpdated || ScriptResult.isFalse(scriptResult) || event.isPreventDefault()) {
            return (P)currentPage;
        }
        return (P)this.doClickAction(currentPage);
    }

    public <P extends Page> P dblClick() throws IOException {
        return this.dblClick(false, false, false);
    }

    public <P extends Page> P dblClick(boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)this.getPage();
        }
        P clickPage = this.click(shiftKey, ctrlKey, altKey);
        if (clickPage != this.getPage()) {
            if (this.mainLog_.isDebugEnabled()) {
                this.mainLog_.debug("dblClick() is ignored, as click() loaded a different page.");
            }
            return clickPage;
        }
        MouseEvent event = new MouseEvent((DomNode)this, "dblclick", shiftKey, ctrlKey, altKey, 0);
        ScriptResult scriptResult = this.fireEvent(event);
        if (scriptResult == null) {
            return clickPage;
        }
        return (P)scriptResult.getNewPage();
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        return defaultPage;
    }

    public final String getLangAttribute() {
        return this.getAttribute("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttribute("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttribute("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttribute("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttribute("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttribute("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttribute("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttribute("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttribute("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttribute("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttribute("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttribute("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttribute("onkeyup");
    }

    protected boolean isStateUpdateFirst() {
        return false;
    }
}

