/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAnchor
extends ClickableElement {
    private static final long serialVersionUID = 7968778206454737178L;
    public static final String TAG_NAME = "a";
    private final transient Log mainLog_ = LogFactory.getLog(this.getClass());

    HtmlAnchor(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    protected Page doClickAction(Page defaultPage, String hrefSuffix) throws IOException {
        String href = this.getHrefAttribute() + hrefSuffix;
        if (this.mainLog_.isDebugEnabled()) {
            this.mainLog_.debug("do click action in window '" + defaultPage.getEnclosingWindow().getName() + "', using href '" + href + "'");
        }
        if (href.length() > 0 && !href.startsWith("#")) {
            HtmlPage page = (HtmlPage)this.getPage();
            if (TextUtil.startsWithIgnoreCase(href, "javascript:")) {
                return page.executeJavaScriptIfPossible(href, "javascript url", this.getStartLineNumber()).getNewPage();
            }
            URL url = page.getFullyQualifiedUrl(href);
            WebRequestSettings settings = new WebRequestSettings(url);
            settings.addAdditionalHeader("Referer", page.getWebResponse().getRequestUrl().toExternalForm());
            if (this.mainLog_.isDebugEnabled()) {
                this.mainLog_.debug("Getting page for " + url.toExternalForm() + ", derived from href '" + href + "', using the originating URL " + page.getWebResponse().getRequestUrl());
            }
            return page.getWebClient().getPage(page.getEnclosingWindow(), page.getResolvedTarget(this.getTargetAttribute()), settings);
        }
        return defaultPage;
    }

    @Override
    protected Page doClickAction(Page defaultPage) throws IOException {
        return this.doClickAction(defaultPage, "");
    }

    public final String getCharsetAttribute() {
        return this.getAttribute("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getHrefAttribute() {
        return this.getAttribute("href").trim();
    }

    public final String getHrefLangAttribute() {
        return this.getAttribute("hreflang");
    }

    public final String getRelAttribute() {
        return this.getAttribute("rel");
    }

    public final String getRevAttribute() {
        return this.getAttribute("rev");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getShapeAttribute() {
        return this.getAttribute("shape");
    }

    public final String getCoordsAttribute() {
        return this.getAttribute("coords");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    public final String getTargetAttribute() {
        return this.getAttribute("target");
    }

    public final Page openLinkInNewWindow() throws MalformedURLException {
        URL target = ((HtmlPage)this.getPage()).getFullyQualifiedUrl(this.getHrefAttribute());
        String windowName = "HtmlAnchor.openLinkInNewWindow() target";
        WebWindow newWindow = this.getPage().getWebClient().openWindow(target, "HtmlAnchor.openLinkInNewWindow() target");
        return newWindow.getEnclosedPage();
    }
}

