/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;

public class DebugFrameImpl
implements DebugFrame {
    private static final Log LOG = LogFactory.getLog(DebugFrameImpl.class);
    private final DebuggableScript functionOrScript_;
    private static final String KEY_LAST_LINE = "DebugFrameImpl#line";
    private static final String KEY_LAST_SOURCE = "DebugFrameImpl#source";

    public DebugFrameImpl(DebuggableScript functionOrScript) {
        this.functionOrScript_ = functionOrScript;
    }

    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        if (LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            String line = this.getFirstLine(cx);
            String source = this.getSourceName(cx);
            sb.append(source).append(":").append(line).append(" ");
            for (Scriptable parent = activation.getParentScope(); parent != null; parent = parent.getParentScope()) {
                sb.append("   ");
            }
            String functionName = this.getFunctionName(thisObj);
            sb.append(functionName).append("(");
            int nbParams = this.functionOrScript_.getParamCount();
            for (int i = 0; i < nbParams; ++i) {
                String argAsString = i < args.length ? this.stringValue(args[i]) : "undefined";
                sb.append(this.getParamName(i)).append(": ").append(argAsString);
                if (i >= nbParams - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            LOG.trace(sb);
        }
    }

    private String stringValue(Object arg) {
        if (arg instanceof NativeFunction) {
            String name = StringUtils.defaultIfEmpty(((NativeFunction)arg).getFunctionName(), "anonymous");
            return "[function " + name + "]";
        }
        if (arg instanceof IdFunctionObject) {
            return "[function " + ((IdFunctionObject)arg).getFunctionName() + "]";
        }
        if (arg instanceof Function) {
            return "[function anonymous]";
        }
        String asString = null;
        try {
            asString = Context.toString(arg);
            if (arg instanceof Event) {
                asString = asString + "<" + ((Event)arg).jsxGet_type() + ">";
            }
        }
        catch (Throwable e) {
            asString = String.valueOf(arg);
        }
        return asString;
    }

    public void onExceptionThrown(Context cx, Throwable t) {
        if (LOG.isTraceEnabled()) {
            if (t instanceof JavaScriptException) {
                JavaScriptException e = (JavaScriptException)t;
                LOG.trace(this.getSourceName(cx) + ":" + this.getFirstLine(cx) + " Exception thrown: " + Context.toString(e.getValue()));
            } else {
                LOG.trace(this.getSourceName(cx) + ":" + this.getFirstLine(cx) + " Exception thrown: " + t.getCause());
            }
        }
    }

    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
    }

    public void onLineChange(Context cx, int lineNumber) {
        cx.putThreadLocal(KEY_LAST_LINE, lineNumber);
        cx.putThreadLocal(KEY_LAST_SOURCE, this.functionOrScript_.getSourceName());
    }

    public void onDebuggerStatement(Context cx) {
    }

    private String getFunctionName(Scriptable thisObj) {
        if (this.functionOrScript_.isFunction()) {
            String name = this.functionOrScript_.getFunctionName();
            if (name != null && name.length() > 0) {
                return name;
            }
            if (thisObj instanceof SimpleScriptable) {
                return "[anonymous]";
            }
            for (Scriptable obj = thisObj; obj != null; obj = obj.getPrototype()) {
                for (Object id : obj.getIds()) {
                    NativeFunction f;
                    Object o;
                    if (!(id instanceof String)) continue;
                    String s = (String)id;
                    if (obj instanceof ScriptableObject) {
                        o = ((ScriptableObject)obj).getGetterOrSetter(s, 0, false);
                        if (o == null) {
                            o = ((ScriptableObject)obj).getGetterOrSetter(s, 0, true);
                            if (o != null && o instanceof Callable) {
                                return "__defineSetter__ " + s;
                            }
                        } else if (o instanceof Callable) {
                            return "__defineGetter__ " + s;
                        }
                    }
                    if (!((o = obj.get(s, obj)) instanceof NativeFunction) || (f = (NativeFunction)o).getDebuggableView() != this.functionOrScript_) continue;
                    return s;
                }
            }
            return "[anonymous]";
        }
        return "[script]";
    }

    private String getParamName(int index) {
        if (index >= 0 && this.functionOrScript_.getParamCount() > index) {
            return this.functionOrScript_.getParamOrVarName(index);
        }
        return "???";
    }

    private String getSourceName(Context cx) {
        String source = (String)cx.getThreadLocal(KEY_LAST_SOURCE);
        if (source == null) {
            return "unknown";
        }
        source = StringUtils.substringAfterLast(source, "/");
        source = StringUtils.substringBefore(source, " ");
        return source;
    }

    private String getFirstLine(Context cx) {
        Object line = cx.getThreadLocal(KEY_LAST_LINE);
        if (line == null) {
            return "unknown";
        }
        return String.valueOf(line);
    }
}

