/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location
extends SimpleScriptable {
    private static final long serialVersionUID = -2907220432378132233L;
    private static final String UNKNOWN = "null";
    private Window window_;
    private String hash_;

    public void initialize(Window window) {
        this.window_ = window;
        if (this.window_ != null && this.window_.getWebWindow().getEnclosedPage() != null) {
            this.hash_ = this.window_.getWebWindow().getEnclosedPage().getWebResponse().getRequestUrl().getRef();
        }
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || String.class.equals(hint)) {
            return this.jsxGet_href();
        }
        return super.getDefaultValue(hint);
    }

    public String toString() {
        if (this.window_ != null) {
            return this.jsxGet_href();
        }
        return "[Uninitialized]";
    }

    public void jsxFunction_assign(String url) throws IOException {
        this.jsxSet_href(url);
    }

    public void jsxFunction_reload(boolean force) throws IOException {
        String url = this.jsxGet_href();
        if (UNKNOWN.equals(url)) {
            this.getLog().error("Unable to reload location: current URL is unknown.");
        } else {
            this.jsxSet_href(url);
        }
    }

    public void jsxFunction_replace(String url) throws IOException {
        this.jsxSet_href(url);
    }

    public String jsxFunction_toString() {
        return this.jsxGet_href();
    }

    public String jsxGet_href() {
        Page page = this.window_.getWebWindow().getEnclosedPage();
        if (page == null) {
            return UNKNOWN;
        }
        try {
            URL url = page.getWebResponse().getRequestUrl();
            boolean encodeHash = !this.getBrowserVersion().isIE();
            String hash = this.getHash(encodeHash);
            if (hash != null) {
                url = UrlUtils.getUrlWithNewRef(url, hash);
            }
            return url.toExternalForm();
        }
        catch (MalformedURLException e) {
            this.getLog().error(e.getMessage(), e);
            return page.getWebResponse().getRequestUrl().toExternalForm();
        }
    }

    public void jsxSet_href(final String newLocation) throws IOException {
        final HtmlPage page = (HtmlPage)Location.getWindow(this.getStartingScope()).getWebWindow().getEnclosedPage();
        PostponedAction action = new PostponedAction(){

            public void execute() throws Exception {
                if (newLocation.startsWith("javascript:")) {
                    String script = newLocation.substring(11);
                    page.executeJavaScriptIfPossible(script, "new location value", 1);
                    return;
                }
                try {
                    URL url = page.getFullyQualifiedUrl(newLocation);
                    URL oldUrl = page.getWebResponse().getRequestUrl();
                    if (url.sameFile(oldUrl) && !StringUtils.equals(url.getRef(), oldUrl.getRef())) {
                        Location.this.jsxSet_hash(newLocation);
                        return;
                    }
                    WebWindow webWindow = Location.this.getWindow().getWebWindow();
                    webWindow.getWebClient().getPage(webWindow, new WebRequestSettings(url));
                }
                catch (MalformedURLException e) {
                    Location.this.getLog().error("jsxSet_location('" + newLocation + "') Got MalformedURLException", e);
                    throw e;
                }
                catch (IOException e) {
                    Location.this.getLog().error("jsxSet_location('" + newLocation + "') Got IOException", e);
                    throw e;
                }
            }
        };
        page.getWebClient().getJavaScriptEngine().addPostponedAction(action);
    }

    public String jsxGet_search() {
        String search = this.getUrl().getQuery();
        if (search == null) {
            return "";
        }
        return "?" + search;
    }

    public void jsxSet_search(String search) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), search));
    }

    public String jsxGet_hash() {
        String hash = this.getHash(false);
        if (hash != null) {
            return "#" + hash;
        }
        return "";
    }

    private String getHash(boolean encoded) {
        if (this.hash_ == null || this.hash_.length() == 0) {
            return null;
        }
        if (encoded) {
            try {
                return URIUtil.encodeQuery(this.hash_);
            }
            catch (URIException e) {
                this.getLog().error(e.getMessage(), e);
            }
        }
        return this.hash_;
    }

    public void jsxSet_hash(String hash) {
        try {
            if (hash != null) {
                boolean decodeHash;
                if (hash.startsWith("#")) {
                    hash = hash.substring(1);
                }
                boolean bl = decodeHash = !this.getBrowserVersion().isIE();
                if (decodeHash) {
                    hash = URIUtil.decode(hash);
                }
                this.hash_ = hash;
            } else {
                this.hash_ = null;
            }
        }
        catch (URIException e) {
            this.getLog().error(e.getMessage(), e);
        }
    }

    public String jsxGet_hostname() {
        return this.getUrl().getHost();
    }

    public void jsxSet_hostname(String hostname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
    }

    public String jsxGet_host() {
        URL url = this.getUrl();
        int port = url.getPort();
        String host = url.getHost();
        if (port == -1) {
            return host;
        }
        return host + ":" + port;
    }

    public void jsxSet_host(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index != -1) {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            hostname = host;
            port = -1;
        }
        URL url1 = UrlUtils.getUrlWithNewHost(this.getUrl(), hostname);
        URL url2 = UrlUtils.getUrlWithNewPort(url1, port);
        this.setUrl(url2);
    }

    public String jsxGet_pathname() {
        if (WebClient.URL_ABOUT_BLANK == this.getUrl()) {
            if (this.getBrowserVersion().isFirefox()) {
                return "";
            }
            return "/blank";
        }
        return this.getUrl().getPath();
    }

    public void jsxSet_pathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    public String jsxGet_port() {
        int port = this.getUrl().getPort();
        if (port == -1) {
            return "";
        }
        return String.valueOf(port);
    }

    public void jsxSet_port(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    public String jsxGet_protocol() {
        return this.getUrl().getProtocol() + ":";
    }

    public void jsxSet_protocol(String protocol) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewProtocol(this.getUrl(), protocol));
    }

    private URL getUrl() {
        return this.window_.getWebWindow().getEnclosedPage().getWebResponse().getRequestUrl();
    }

    private void setUrl(URL url) throws IOException {
        this.window_.getWebWindow().getWebClient().getPage(this.window_.getWebWindow(), new WebRequestSettings(url));
    }
}

