/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.DialogWindow;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.NonSerializable;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObject;
import com.gargoylesoftware.htmlunit.javascript.host.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLUnknownElement;
import com.gargoylesoftware.htmlunit.javascript.host.History;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Navigator;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Popup;
import com.gargoylesoftware.htmlunit.javascript.host.Screen;
import com.gargoylesoftware.htmlunit.javascript.host.Selection;
import com.gargoylesoftware.htmlunit.javascript.host.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.Stylesheet;
import com.gargoylesoftware.htmlunit.javascript.host.XMLDocument;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Window
extends SimpleScriptable
implements ScriptableWithFallbackGetter {
    private static final long serialVersionUID = -7730298149962810325L;
    private HTMLDocument document_;
    private Navigator navigator_;
    private WebWindow webWindow_;
    private Screen screen_;
    private History history_;
    private Location location_;
    private Object event_;
    private String status_ = "";
    private HTMLCollection frames_;
    private Map<Class<? extends SimpleScriptable>, Scriptable> prototypes_ = new HashMap<Class<? extends SimpleScriptable>, Scriptable>();
    private final JavaScriptEngine scriptEngine_;
    private EventListenersContainer eventListenersContainer_;
    private Object controllers_;
    private Map<Node, ComputedCSSStyleDeclaration> computedStyles_ = new WeakHashMap<Node, ComputedCSSStyleDeclaration>();

    public Window(JavaScriptEngine scriptEngine) {
        this.scriptEngine_ = scriptEngine;
    }

    public JavaScriptEngine getJavaScriptEngine() {
        return this.scriptEngine_;
    }

    @Override
    public Scriptable getPrototype(Class<? extends SimpleScriptable> jsClass) {
        return this.prototypes_.get(jsClass);
    }

    public void setPrototypes(Map<Class<? extends SimpleScriptable>, Scriptable> map) {
        this.prototypes_ = map;
    }

    public void jsxFunction_alert(Object message) {
        String stringMessage = Context.toString(message);
        AlertHandler handler = this.getWebWindow().getWebClient().getAlertHandler();
        if (handler == null) {
            this.getLog().warn("window.alert(\"" + stringMessage + "\") no alert handler installed");
        } else {
            handler.handleAlert(this.document_.getHtmlPage(), stringMessage);
        }
    }

    public boolean jsxFunction_confirm(String message) {
        ConfirmHandler handler = this.getWebWindow().getWebClient().getConfirmHandler();
        if (handler == null) {
            this.getLog().warn("window.confirm(\"" + message + "\") no confirm handler installed, simulating the OK button");
            return true;
        }
        return handler.handleConfirm(this.document_.getHtmlPage(), message);
    }

    public String jsxFunction_prompt(String message) {
        PromptHandler handler = this.getWebWindow().getWebClient().getPromptHandler();
        if (handler == null) {
            this.getLog().warn("window.prompt(\"" + message + "\") no prompt handler installed");
            return null;
        }
        return handler.handlePrompt(this.document_.getHtmlPage(), message);
    }

    public HTMLDocument jsxGet_document() {
        return this.document_;
    }

    public Object jsxGet_event() {
        return this.event_;
    }

    public void setEvent(Object event) {
        this.event_ = event;
    }

    public Object jsxFunction_open(Object url, Object name, Object features, Object replace) {
        WebClient webClient;
        String urlString = null;
        if (url != Undefined.instance) {
            urlString = (String)url;
        }
        String windowName = "";
        if (name != Undefined.instance) {
            windowName = (String)name;
        }
        String featuresString = null;
        if (features != Undefined.instance) {
            featuresString = (String)features;
        }
        boolean replaceCurrentEntryInBrowsingHistory = false;
        if (replace != Undefined.instance) {
            replaceCurrentEntryInBrowsingHistory = (Boolean)replace;
        }
        if ((webClient = this.webWindow_.getWebClient()).isPopupBlockerEnabled()) {
            this.getLog().debug("Ignoring window.open() invocation because popups are blocked.");
            return null;
        }
        if (featuresString != null || replaceCurrentEntryInBrowsingHistory) {
            this.getLog().debug("window.open: features and replaceCurrentEntryInBrowsingHistory not implemented: url=[" + urlString + "] windowName=[" + windowName + "] features=[" + featuresString + "] replaceCurrentEntry=[" + replaceCurrentEntryInBrowsingHistory + "]");
        }
        if (StringUtils.isEmpty(urlString) && !"".equals(windowName)) {
            try {
                WebWindow webWindow = webClient.getWebWindowByName(windowName);
                return webWindow.getScriptObject();
            }
            catch (WebWindowNotFoundException e) {
                // empty catch block
            }
        }
        URL newUrl = this.makeUrlForOpenWindow(urlString);
        WebWindow newWebWindow = webClient.openWindow(newUrl, windowName, this.webWindow_);
        return newWebWindow.getScriptObject();
    }

    public Popup jsxFunction_createPopup() {
        Popup popup = new Popup();
        popup.setParentScope(this);
        popup.setPrototype(this.getPrototype(Popup.class));
        popup.init(this);
        return popup;
    }

    private URL makeUrlForOpenWindow(String urlString) {
        if (urlString.length() == 0) {
            return WebClient.URL_ABOUT_BLANK;
        }
        try {
            Page page = this.webWindow_.getEnclosedPage();
            if (page != null && page instanceof HtmlPage) {
                return ((HtmlPage)page).getFullyQualifiedUrl(urlString);
            }
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            this.getLog().error("Unable to create URL for openWindow: relativeUrl=[" + urlString + "]", e);
            return null;
        }
    }

    public int jsxFunction_setTimeout(Object codeToExec, int timeout, Object language) {
        this.getLog().debug("setTimeout(" + codeToExec + ", " + timeout + ")");
        int id = this.getWebWindow().getThreadManager().registerJob(codeToExec, timeout, "window.setTimeout");
        return id;
    }

    public void jsxFunction_clearTimeout(int timeoutId) {
        this.getWebWindow().getThreadManager().removeJob(timeoutId);
    }

    public Navigator jsxGet_navigator() {
        return this.navigator_;
    }

    public Window jsxGet_window() {
        return this;
    }

    public Window jsxGet_self() {
        return this;
    }

    public Location jsxGet_location() {
        return this.location_;
    }

    public void jsxSet_location(String newLocation) throws IOException {
        this.location_.jsxSet_href(newLocation);
    }

    public Screen jsxGet_screen() {
        return this.screen_;
    }

    public History jsxGet_history() {
        return this.history_;
    }

    public void initialize(WebWindow webWindow) {
        this.webWindow_ = webWindow;
        this.webWindow_.setScriptObject(this);
        this.document_ = new HTMLDocument();
        this.document_.setParentScope(this);
        this.document_.setPrototype(this.getPrototype(HTMLDocument.class));
        this.document_.setWindow(this);
        if (webWindow.getEnclosedPage() instanceof DomNode) {
            this.document_.setDomNode((DomNode)((Object)webWindow.getEnclosedPage()));
        }
        DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
        DomNode docNode = this.document_.getDomNodeOrNull();
        if (docNode != null) {
            docNode.addDomChangeListener(listener);
            if (docNode instanceof HtmlElement) {
                ((HtmlElement)docNode).addHtmlAttributeChangeListener(listener);
            }
        }
        this.navigator_ = new Navigator();
        this.navigator_.setParentScope(this);
        this.navigator_.setPrototype(this.getPrototype(Navigator.class));
        this.screen_ = new Screen();
        this.screen_.setParentScope(this);
        this.screen_.setPrototype(this.getPrototype(Screen.class));
        this.history_ = new History();
        this.history_.setParentScope(this);
        this.history_.setPrototype(this.getPrototype(History.class));
        this.location_ = new Location();
        this.location_.setParentScope(this);
        this.location_.setPrototype(this.getPrototype(Location.class));
        this.location_.initialize(this);
        Context ctx = Context.getCurrentContext();
        this.controllers_ = ctx.newObject(this);
    }

    public void initialize(Page enclosedPage) {
        if (enclosedPage instanceof HtmlPage) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            this.setDomNode(htmlPage);
            this.eventListenersContainer_ = null;
            WebAssert.notNull("document_", this.document_);
            this.document_.setDomNode(htmlPage);
        }
    }

    public void initialize() {
    }

    public SimpleScriptable jsxGet_top() {
        WebWindow topWebWindow = this.webWindow_.getTopWindow();
        return (SimpleScriptable)topWebWindow.getScriptObject();
    }

    public SimpleScriptable jsxGet_parent() {
        WebWindow parentWebWindow = this.webWindow_.getParentWindow();
        return (SimpleScriptable)parentWebWindow.getScriptObject();
    }

    public Object jsxGet_opener() {
        WebWindow opener;
        if (this.webWindow_ instanceof TopLevelWindow && (opener = ((TopLevelWindow)this.webWindow_).getOpener()) != null) {
            return opener.getScriptObject();
        }
        return null;
    }

    public Object jsxGet_frameElement() {
        WebWindow window = this.getWebWindow();
        if (window instanceof FrameWindow) {
            return ((FrameWindow)window).getFrameElement().getScriptObject();
        }
        return null;
    }

    public HTMLCollection jsxGet_frames() {
        if (this.frames_ == null) {
            String xpath = ".//*[(name() = 'frame' or name() = 'iframe')]";
            HtmlPage page = (HtmlPage)this.getWebWindow().getEnclosedPage();
            this.frames_ = new HTMLCollection(this);
            Transformer toEnclosedWindow = new Transformer(){

                public Object transform(Object obj) {
                    if (obj instanceof BaseFrame) {
                        return ((BaseFrame)obj).getEnclosedWindow();
                    }
                    return ((FrameWindow)obj).getFrameElement().getEnclosedWindow();
                }
            };
            this.frames_.init(page, ".//*[(name() = 'frame' or name() = 'iframe')]", toEnclosedWindow);
        }
        return this.frames_;
    }

    public WebWindow getWebWindow() {
        return this.webWindow_;
    }

    public void jsxFunction_focus() {
        this.webWindow_.getWebClient().setCurrentWindow(this.webWindow_);
    }

    public void jsxFunction_blur() {
        this.getLog().debug("window.blur() not implemented");
    }

    public void jsxFunction_close() {
        this.getWebWindow().getWebClient().deregisterWebWindow(this.getWebWindow());
    }

    public boolean jsxGet_closed() {
        return !this.getWebWindow().getWebClient().getWebWindows().contains(this.getWebWindow());
    }

    public void jsxFunction_moveTo(int x, int y) {
        this.getLog().debug("window.moveTo() not implemented");
    }

    public void jsxFunction_moveBy(int x, int y) {
        this.getLog().debug("window.moveBy() not implemented");
    }

    public void jsxFunction_resizeBy(int width, int height) {
        this.getLog().debug("window.resizeBy() not implemented");
    }

    public void jsxFunction_resizeTo(int width, int height) {
        this.getLog().debug("window.resizeTo() not implemented");
    }

    public void jsxFunction_scroll(int x, int y) {
        this.getLog().debug("window.scroll() not implemented");
    }

    public void jsxFunction_scrollBy(int x, int y) {
        this.getLog().debug("window.scrollBy() not implemented");
    }

    public void jsxFunction_scrollByLines(int lines) {
        this.getLog().debug("window.scrollByLines() not implemented");
    }

    public void jsxFunction_scrollByPages(int pages) {
        this.getLog().debug("window.scrollByPages() not implemented");
    }

    public void jsxFunction_scrollTo(int x, int y) {
        this.getLog().debug("window.scrollTo() not implemented");
    }

    public void jsxSet_onload(Object newOnload) {
        this.getEventListenersContainer().setEventHandlerProp("load", newOnload);
    }

    public void jsxSet_onclick(Object newOnload) {
        this.getEventListenersContainer().setEventHandlerProp("click", newOnload);
    }

    public Object jsxGet_onclick() {
        return this.getEventListenersContainer().getEventHandlerProp("click");
    }

    public void jsxSet_ondblclick(Object newHandler) {
        this.getEventListenersContainer().setEventHandlerProp("dblclick", newHandler);
    }

    public Object jsxGet_ondblclick() {
        return this.getEventListenersContainer().getEventHandlerProp("dblclick");
    }

    public Object jsxGet_onload() {
        Object onload = this.getEventListenersContainer().getEventHandlerProp("load");
        if (onload == null) {
            HtmlPage page = (HtmlPage)this.webWindow_.getEnclosedPage();
            HtmlElement body = page.getBody();
            if (body != null) {
                return body.getEventHandler("onload");
            }
            return null;
        }
        return onload;
    }

    EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    public boolean jsxFunction_attachEvent(String type, Function listener) {
        return this.getEventListenersContainer().addEventListener(StringUtils.substring(type, 2), listener, false);
    }

    public void jsxFunction_addEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    public void jsxFunction_detachEvent(String type, Function listener) {
        this.getEventListenersContainer().removeEventListener(StringUtils.substring(type, 2), listener, false);
    }

    public void jsxFunction_removeEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().removeEventListener(type, listener, useCapture);
    }

    public String jsxGet_name() {
        return this.webWindow_.getName();
    }

    public void jsxSet_name(String newName) {
        this.webWindow_.setName(newName);
    }

    public String jsxGet_onerror() {
        this.getLog().debug("window.onerror not implemented");
        return "";
    }

    public void jsxSet_onerror(String newValue) {
        this.getLog().debug("window.onerror not implemented");
    }

    @Override
    public Object getWithFallback(String name) {
        HtmlPage page;
        Object result = NOT_FOUND;
        DomNode domNode = this.getDomNodeOrNull();
        if (domNode != null && (result = Window.getFrameByName(page = (HtmlPage)domNode.getPage(), name)) == NOT_FOUND) {
            List<HtmlElement> elements = page.getElementsByName(name);
            if (elements.size() == 1) {
                result = this.getScriptableFor(elements.get(0));
            } else if (elements.size() > 1) {
                result = this.document_.jsxFunction_getElementsByName(name);
            } else {
                try {
                    Object htmlElement = page.getHtmlElementById(name);
                    result = this.getScriptableFor(htmlElement);
                }
                catch (ElementNotFoundException e) {
                    result = NOT_FOUND;
                }
            }
        }
        return result;
    }

    @Override
    public Object get(String name, Scriptable start) {
        HtmlElement unknownElement;
        Object element;
        if ("eval".equals(name)) {
            Window w = (Window)Window.getTopScope(this.getStartingScope());
            if (w != this) {
                return this.getAssociatedValue("custom_eval");
            }
        } else if ("Option".equals(name)) {
            name = "HTMLOptionElement";
        } else if ("Image".equals(name)) {
            name = "HTMLImageElement";
        }
        Object superValue = super.get(name, start);
        if (superValue == NOT_FOUND && this.getWebWindow() != null && this.getBrowserVersion().isIE() && (element = this.jsxGet_document().jsxFunction_getElementById(name)) instanceof HTMLUnknownElement && (unknownElement = ((HTMLUnknownElement)element).getHtmlElementOrDie()).getNodeName().equals("xml")) {
            XMLDocument document = ActiveXObject.buildXMLDocument(this.getWebWindow());
            document.setParentScope(this);
            Iterator<HtmlElement> children = unknownElement.getAllHtmlChildElements().iterator();
            if (children.hasNext()) {
                HtmlElement root = children.next();
                document.jsxFunction_loadXML(root.asXml().trim());
            }
            return document;
        }
        return superValue;
    }

    private static Scriptable getTopScope(Scriptable s) {
        Scriptable top;
        for (top = s; top != null && top.getParentScope() != null; top = top.getParentScope()) {
        }
        return top;
    }

    private static Object getFrameByName(HtmlPage page, String name) {
        try {
            return page.getFrameByName(name).getScriptObject();
        }
        catch (ElementNotFoundException e) {
            return NOT_FOUND;
        }
    }

    public Object jsxFunction_execScript(String script, Object language) {
        String languageStr = Context.toString(language);
        if (language == Undefined.instance || "javascript".equalsIgnoreCase(languageStr) || "jscript".equalsIgnoreCase(languageStr)) {
            this.custom_eval(script);
            return null;
        }
        if (!"vbscript".equalsIgnoreCase(languageStr)) {
            throw Context.reportRuntimeError("Invalid class string");
        }
        this.getLog().warn("VBScript not supported in Window.execScript().");
        return null;
    }

    public Object custom_eval(String scriptCode) {
        Context context = Context.getCurrentContext();
        Script script = context.compileString(scriptCode, "eval body", 0, null);
        return script.exec(context, this);
    }

    public String jsxGet_status() {
        return this.status_;
    }

    public void jsxSet_status(String message) {
        this.status_ = message;
        StatusHandler statusHandler = this.webWindow_.getWebClient().getStatusHandler();
        if (statusHandler != null) {
            statusHandler.statusMessageChanged(this.webWindow_.getEnclosedPage(), message);
        }
    }

    public int jsxFunction_setInterval(Object codeToExec, int timeout, Object language) {
        this.getLog().debug("setInterval(" + codeToExec + ", " + timeout + ")");
        int id = this.getWebWindow().getThreadManager().registerRecurringJob(codeToExec, timeout, "window.setInterval");
        return id;
    }

    public void jsxFunction_clearInterval(int intervalID) {
        this.getWebWindow().getThreadManager().removeJob(intervalID);
    }

    public int jsxGet_innerWidth() {
        return 1276;
    }

    public int jsxGet_outerWidth() {
        return 1276;
    }

    public int jsxGet_innerHeight() {
        return 778;
    }

    public int jsxGet_outerHeight() {
        return 936;
    }

    public void jsxFunction_print() {
        this.getLog().debug("window.print() not implemented");
    }

    public void jsxFunction_captureEvents(String type) {
    }

    public void jsxFunction_CollectGarbage() {
    }

    public ComputedCSSStyleDeclaration jsxFunction_getComputedStyle(HTMLElement element, String pseudo) {
        ComputedCSSStyleDeclaration style = this.computedStyles_.get(element);
        if (style != null) {
            return style;
        }
        CSSStyleDeclaration original = element.jsxGet_style();
        style = new ComputedCSSStyleDeclaration(original);
        StyleSheetList sheets = this.document_.jsxGet_styleSheets();
        for (int i = 0; i < sheets.jsxGet_length(); ++i) {
            Stylesheet sheet = (Stylesheet)sheets.jsxFunction_item(i);
            this.getLog().debug("modifyIfNecessary: " + sheet + ", " + style + ", " + element);
            sheet.modifyIfNecessary(style, element);
        }
        this.computedStyles_.put(element, style);
        return style;
    }

    public Selection jsxFunction_getSelection() {
        Selection selection = new Selection();
        selection.setParentScope(this);
        selection.setPrototype(this.getPrototype(selection.getClass()));
        return selection;
    }

    public Object jsxFunction_showModalDialog(String url, Object arguments, String features) {
        WebWindow ww = this.getWebWindow();
        WebClient client = ww.getWebClient();
        try {
            DialogWindow dialog = client.openDialogWindow(new URL(url), ww, arguments);
            ScriptableObject jsDialog = (ScriptableObject)dialog.getScriptObject();
            return jsDialog.get("returnValue", (Scriptable)jsDialog);
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    public Object jsxFunction_showModelessDialog(String url, Object arguments, String features) {
        WebWindow ww = this.getWebWindow();
        WebClient client = ww.getWebClient();
        try {
            DialogWindow dialog = client.openDialogWindow(new URL(url), ww, arguments);
            Window jsDialog = (Window)dialog.getScriptObject();
            return jsDialog;
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    public Object jsxGet_controllers() {
        return this.controllers_;
    }

    public void jsxSet_controllers(Object value) {
        this.controllers_ = value;
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener,
    NonSerializable {
        private DomHtmlAttributeChangeListenerImpl() {
        }

        public void nodeAdded(DomChangeEvent event) {
            this.nodeChanged(event.getChangedNode());
        }

        public void nodeDeleted(DomChangeEvent event) {
            this.nodeChanged(event.getChangedNode());
        }

        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement());
        }

        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement());
        }

        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement());
        }

        private void nodeChanged(DomNode changed) {
            String rel;
            if (changed instanceof HtmlStyle) {
                Window.this.computedStyles_.clear();
                return;
            }
            if (changed instanceof HtmlLink && "stylesheet".equals(rel = ((HtmlLink)changed).getRelAttribute().toLowerCase())) {
                Window.this.computedStyles_.clear();
                return;
            }
            Iterator i = Window.this.computedStyles_.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                DomNode node = ((Node)entry.getKey()).getDomNodeOrDie();
                if (changed != node && changed.getParentNode() != node.getParentNode() && !changed.isAncestorOf(node)) continue;
                i.remove();
            }
        }
    }
}

