/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.weblogic;

import java.io.File;
import java.io.IOException;
import org.apache.cactus.integration.ant.container.AbstractJavaContainer;
import org.apache.cactus.integration.ant.util.ResourceUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;

public class WebLogic7xContainer
extends AbstractJavaContainer {
    private File beaHome;
    private File dir;
    private int port = 8080;
    private File configXml;
    private File tmpDir;

    public final void setBeaHome(File theBeaHome) {
        this.beaHome = theBeaHome;
    }

    public final void setDir(File theDir) {
        this.dir = theDir;
    }

    public final void setPort(int thePort) {
        this.port = thePort;
    }

    public final void setConfigXml(File theConfigXml) {
        this.configXml = theConfigXml;
    }

    public final void setTmpDir(File theTmpDir) {
        this.tmpDir = theTmpDir;
    }

    public final String getName() {
        return "WebLogic 7.x";
    }

    public final int getPort() {
        return this.port;
    }

    public final void init() {
        if (!this.dir.isDirectory()) {
            throw new BuildException(this.dir + " is not a directory");
        }
        if (this.beaHome == null) {
            this.getLog().debug("Extrapolating beaHome to be [" + this.dir.getParentFile() + "]");
            this.beaHome = this.dir.getParentFile();
        }
    }

    public final void startUp() {
        try {
            this.prepare("cactus/weblogic7x");
            Java java = this.createJavaForStartUp();
            java.setDir(new File(this.tmpDir, "testdomain"));
            java.createJvmarg().setValue("-hotspot");
            java.createJvmarg().setValue("-Xms32m");
            java.createJvmarg().setValue("-Xmx200m");
            File serverDir = new File(this.dir, "server");
            java.addSysproperty(this.createSysProperty("weblogic.Name", "testserver"));
            java.addSysproperty(this.createSysProperty("bea.home", this.beaHome));
            java.addSysproperty(this.createSysProperty("weblogic.management.username", "weblogic"));
            java.addSysproperty(this.createSysProperty("weblogic.management.password", "weblogic"));
            java.addSysproperty(this.createSysProperty("java.security.policy", "=./server/lib/weblogic.policy"));
            Path classpath = java.createClasspath();
            classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic_sp.jar"));
            classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic.jar"));
            java.setClassname("weblogic.Server");
            java.execute();
        }
        catch (IOException ioe) {
            this.getLog().error("Failed to startup the container", ioe);
            throw new BuildException((Throwable)ioe);
        }
    }

    public final void shutDown() {
        Java java = this.createJavaForShutDown();
        File serverDir = new File(this.dir, "server");
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic_sp.jar"));
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic.jar"));
        java.setClassname("weblogic.Admin");
        java.createArg().setValue("-url");
        java.createArg().setValue("t3://" + this.getServer() + ":" + this.getPort());
        java.createArg().setValue("-username");
        java.createArg().setValue("weblogic");
        java.createArg().setValue("-password");
        java.createArg().setValue("weblogic");
        java.createArg().setValue("FORCESHUTDOWN");
        java.execute();
    }

    private void prepare(String theDirName) throws IOException {
        FileUtils fileUtils = FileUtils.newFileUtils();
        FilterChain filterChain = this.createFilterChain();
        this.tmpDir = this.setupTempDirectory(this.tmpDir, theDirName);
        this.cleanTempDirectory(this.tmpDir);
        File testDomainDir = this.createDirectory(this.tmpDir, "testdomain");
        if (this.configXml != null) {
            fileUtils.copyFile(this.configXml, new File(testDomainDir, "config.xml"));
        } else {
            ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/config.xml", new File(testDomainDir, "config.xml"), filterChain);
        }
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/DefaultAuthenticatorInit.ldift", new File(testDomainDir, "DefaultAuthenticatorInit.ldift"), filterChain);
        File weblogicXml = new File(this.tmpDir, "weblogic.xml");
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/weblogic.xml", weblogicXml, filterChain);
        File applicationsDir = this.createDirectory(testDomainDir, "applications");
        Jar jar = (Jar)this.createAntTask("jar");
        jar.setDestFile(new File(applicationsDir, this.getDeployableFile().getFile().getName()));
        ZipFileSet zip = new ZipFileSet();
        zip.setSrc(this.getDeployableFile().getFile());
        jar.addZipfileset(zip);
        ZipFileSet fileSet = new ZipFileSet();
        fileSet.setDir(this.tmpDir);
        fileSet.createInclude().setName("weblogic.xml");
        fileSet.setPrefix("WEB-INF");
        jar.addZipfileset(fileSet);
        jar.execute();
    }
}

