/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.internal.jetty.JettyStandaloneConfigurationCapability;
import org.codehaus.cargo.container.spi.AbstractStandaloneConfiguration;

public class JettyStandaloneConfiguration
extends AbstractStandaloneConfiguration {
    private ConfigurationCapability capability = new JettyStandaloneConfigurationCapability();

    public JettyStandaloneConfiguration(Container container) {
        super(container);
    }

    public JettyStandaloneConfiguration(Container container, File configDir) {
        super(container, configDir);
    }

    public ConfigurationCapability getCapability() {
        return this.capability;
    }

    public void configure() {
        try {
            this.createConfigurationDir();
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(this.getDir(), "cargocpc.war"));
            this.activateLogging();
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + this.getContainer().getName() + " container configuration", e);
        }
    }

    private void activateLogging() throws Exception {
        Class<?> outputStreamLogSinkClass = Class.forName("org.mortbay.util.OutputStreamLogSink");
        Object sink = outputStreamLogSinkClass.getConstructor(String.class).newInstance(this.getContainer().getOutput().getPath());
        outputStreamLogSinkClass.getMethod("setAppend", Boolean.TYPE).invoke(sink, this.getContainer().isAppend());
        outputStreamLogSinkClass.getMethod("start", null).invoke(sink, null);
        Class<?> sinkClass = Class.forName("org.mortbay.util.LogSink");
        Class<?> logClass = Class.forName("org.mortbay.util.Log");
        Object log = logClass.getMethod("instance", null).invoke(null, null);
        logClass.getMethod("disableLog", null).invoke(log, null);
        logClass.getMethod("add", sinkClass).invoke(log, sink);
        String logLevel = this.getPropertyValue("cargo.logging");
        if (logLevel.equalsIgnoreCase("high")) {
            Class<?> codeClass = Class.forName("org.mortbay.util.Code");
            codeClass.getMethod("setDebug", Boolean.TYPE).invoke(null, Boolean.TRUE);
        }
    }
}

