/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.StandaloneConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.spi.AbstractConfiguration;

public abstract class AbstractStandaloneConfiguration
extends AbstractConfiguration
implements StandaloneConfiguration {
    private List deployables = new ArrayList();

    public AbstractStandaloneConfiguration(Container container) {
        this(container, new File(System.getProperty("java.io.tmpdir"), container.getId()));
    }

    public AbstractStandaloneConfiguration(Container container, File configDir) {
        super(container, configDir);
        this.setProperty("cargo.logging", "medium");
    }

    public void addDeployable(Deployable war) {
        this.deployables.add(war);
    }

    public List getDeployables() {
        return this.deployables;
    }

    protected void createConfigurationDir() throws IOException {
        File timestampFile = new File(this.getDir(), ".cargo");
        if (this.getDir().exists()) {
            if (this.getDir().list().length == 0) {
                timestampFile.createNewFile();
            }
        } else {
            if (!this.getDir().mkdirs()) {
                throw new IOException("Could not create configuration directory [" + this.getDir() + "]");
            }
            timestampFile.createNewFile();
        }
        if (!timestampFile.exists()) {
            throw new ContainerException("Invalid configuration dir [" + this.getDir() + "]. The configuration dir must point to an empty directory. Note that " + "everything in the configuration dir will get deleted by Cargo.");
        }
        this.cleanConfigurationDirectory();
    }

    private void cleanConfigurationDirectory() {
        Delete delete = (Delete)this.getAntUtils().createAntTask("delete");
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.getDir());
        fileSet.createInclude().setName("**/*");
        fileSet.createExclude().setName(".cargo");
        fileSet.setDefaultexcludes(false);
        delete.addFileset(fileSet);
        delete.setIncludeEmptyDirs(true);
        delete.setFailOnError(true);
        delete.setQuiet(false);
        delete.execute();
    }

    protected final FilterChain createFilterChain() {
        FilterChain filterChain = new FilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.servlet.port", this.getPropertyValue("cargo.servlet.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.hostname", this.getPropertyValue("cargo.hostname"));
        return filterChain;
    }

    public void verifyProperties() {
        this.verifyServletPortProperty();
        this.verifyLogging();
    }

    private void verifyServletPortProperty() {
        try {
            Integer.parseInt(this.getPropertyValue("cargo.servlet.port"));
        }
        catch (NumberFormatException e) {
            throw new ContainerException("Invalid port number [" + this.getPropertyValue("cargo.servlet.port") + "]. The port value must be an integer", e);
        }
    }

    private void verifyLogging() {
        String level = this.getPropertyValue("cargo.logging");
        if (!(level.equalsIgnoreCase("low") || level.equalsIgnoreCase("medium") || level.equalsIgnoreCase("high"))) {
            throw new ContainerException("Invalid logging level [" + level + "]. Valid levels are {\"low\", \"medium\", " + "\"high\"}");
        }
    }
}

