/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.ejb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.cargo.module.DefaultJarArchive;
import org.codehaus.cargo.module.ejb.EjbArchive;
import org.codehaus.cargo.module.ejb.EjbJarXml;
import org.codehaus.cargo.module.ejb.EjbJarXmlIo;
import org.codehaus.cargo.module.ejb.orion.OrionEjbJarXml;
import org.codehaus.cargo.module.ejb.orion.OrionEjbJarXmlIo;
import org.codehaus.cargo.module.ejb.weblogic.WeblogicEjbJarXml;
import org.codehaus.cargo.module.ejb.weblogic.WeblogicEjbJarXmlIo;
import org.codehaus.cargo.module.ejb.websphere.IbmEjbJarBndXmi;
import org.codehaus.cargo.module.ejb.websphere.IbmEjbJarBndXmiIo;
import org.xml.sax.SAXException;

public class DefaultEjbArchive
extends DefaultJarArchive
implements EjbArchive {
    private EjbJarXml ejbJarXml;

    public DefaultEjbArchive(File theFile) throws IOException {
        super(theFile);
    }

    public DefaultEjbArchive(InputStream theInputStream) throws IOException {
        super(theInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EjbJarXml getEjbJarXml() throws IOException, SAXException, ParserConfigurationException {
        if (this.ejbJarXml == null) {
            InputStream in = null;
            try {
                in = this.getResource("META-INF/ejb-jar.xml");
                this.ejbJarXml = EjbJarXmlIo.parseEjbJarXml(in, null);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.addWeblogicDescriptor();
            this.addOracleDescriptor();
            this.addWebsphereDescriptor();
        }
        return this.ejbJarXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWeblogicDescriptor() throws IOException, SAXException, ParserConfigurationException {
        InputStream in = null;
        try {
            WeblogicEjbJarXml descr;
            in = this.getResource("META-INF/weblogic-ejb-jar.xml");
            if (in != null && (descr = WeblogicEjbJarXmlIo.parseWeblogicEjbJarXml(in)) != null) {
                this.ejbJarXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOracleDescriptor() throws IOException, SAXException, ParserConfigurationException {
        InputStream in = null;
        try {
            OrionEjbJarXml descr;
            in = this.getResource("META-INF/orion-ejb-jar.xml");
            if (in != null && (descr = OrionEjbJarXmlIo.parseOracleEjbJarXml(in)) != null) {
                this.ejbJarXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWebsphereDescriptor() throws IOException, SAXException, ParserConfigurationException {
        InputStream in = null;
        try {
            IbmEjbJarBndXmi descr;
            in = this.getResource("META-INF/ibm-ejb-jar.bnd.xmi");
            if (in != null && (descr = IbmEjbJarBndXmiIo.parseIbmEjbJarXmi(in)) != null) {
                this.ejbJarXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

