/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util.monitor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.monitor.Monitor;

public class FileMonitor
implements Monitor {
    private FileOutputStream output;
    private final DateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");

    public FileMonitor(File file, boolean append) {
        try {
            this.output = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to create file [" + file + "]", e);
        }
    }

    public FileMonitor(String file, boolean append) {
        this(new File(file), append);
    }

    public void warn(String message, String category) {
        this.log("warn", message, category);
    }

    public void info(String message, String category) {
        this.log("info", message, category);
    }

    public void debug(String message, String category) {
        this.log("dbug", message, category);
    }

    private void log(String severity, String message, String category) {
        String formattedCategory = category.length() > 20 ? category.substring(category.length() - 20) : category;
        String msg = "[" + this.format.format(new Date()) + "]" + "[" + severity + "][" + formattedCategory + "] " + message + "\n";
        try {
            this.output.write(msg.getBytes());
        }
        catch (IOException e) {
            throw new CargoException("Failed to write log message [" + msg + "]", e);
        }
    }
}

