/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.context;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.jsfunit.context.JSFUnitExternalContext;

public class JSFUnitHttpServletRequest
implements HttpServletRequest {
    private JSFUnitExternalContext extCtx;
    private boolean isServlet14OrGreater = false;
    private String localName = "";
    private String localAddr = "";
    private int localPort = 0;
    private int remotePort = 0;
    private String queryString;
    private String protocol;
    private String pathTranslated;
    private String method;
    private Map parameterMap;
    private int contentLength;
    private Cookie[] cookies;
    private String remoteAddr;
    private String remoteHost;
    private String requestURI;
    private StringBuffer requestURL;
    private String requestedSessionId;
    private String scheme;
    private String serverName;
    private int serverPort;
    private boolean isRequestedSessionIdFromCookie;
    private boolean isRequestedSessionIdFromURL;
    private boolean isRequestedSessionIdValid;
    private boolean isSecure;

    public JSFUnitHttpServletRequest(JSFUnitExternalContext extCtx, HttpServletRequest request) {
        this.extCtx = extCtx;
        this.isServlet14OrGreater = this.isServlet14OrGreater();
        this.cacheServlet14RequestValues(request);
        this.queryString = request.getQueryString();
        this.protocol = request.getProtocol();
        this.pathTranslated = request.getPathTranslated();
        this.method = request.getMethod();
        this.parameterMap = request.getParameterMap();
        this.contentLength = request.getContentLength();
        this.cookies = request.getCookies();
        this.remoteAddr = request.getRemoteAddr();
        this.remoteHost = request.getRemoteHost();
        this.requestURI = request.getRequestURI();
        this.requestURL = new StringBuffer(request.getRequestURL());
        this.requestedSessionId = request.getRequestedSessionId();
        this.scheme = request.getScheme();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.isRequestedSessionIdFromCookie = request.isRequestedSessionIdFromCookie();
        this.isRequestedSessionIdFromURL = request.isRequestedSessionIdFromURL();
        this.isRequestedSessionIdValid = request.isRequestedSessionIdValid();
        this.isSecure = request.isSecure();
    }

    private boolean isServlet14OrGreater() {
        ServletContext servletContext = (ServletContext)this.extCtx.getContext();
        return servletContext.getMinorVersion() > 3;
    }

    private void cacheServlet14RequestValues(HttpServletRequest request) {
        if (!this.isServlet14OrGreater) {
            return;
        }
        this.localName = request.getLocalName();
        this.localAddr = request.getLocalAddr();
        this.localPort = request.getLocalPort();
        this.remotePort = request.getRemotePort();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getPathInfo() {
        return this.extCtx.getRequestPathInfo();
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.extCtx.getRequestParameterMap().keySet());
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    public String getMethod() {
        return this.method;
    }

    public Enumeration getLocales() {
        return this.makeEnumeration(this.extCtx.getRequestLocales());
    }

    private Enumeration makeEnumeration(Iterator iterator) {
        HashSet mySet = new HashSet();
        while (iterator.hasNext()) {
            mySet.add(iterator.next());
        }
        return Collections.enumeration(mySet);
    }

    public Locale getLocale() {
        return this.extCtx.getRequestLocale();
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.extCtx.getRequestMap().keySet());
    }

    public String getAuthType() {
        return this.extCtx.getAuthType();
    }

    public String getCharacterEncoding() {
        return this.extCtx.getRequestCharacterEncoding();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.extCtx.getRequestContentType();
    }

    public String getContextPath() {
        return this.extCtx.getRequestContextPath();
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.extCtx.getRequestHeaderMap().keySet());
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteUser() {
        return this.extCtx.getRemoteUser();
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getServletPath() {
        return this.extCtx.getRequestServletPath();
    }

    public HttpSession getSession() {
        return (HttpSession)this.extCtx.getSession(true);
    }

    public Principal getUserPrincipal() {
        return this.extCtx.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.isRequestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.isRequestedSessionIdValid;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public HttpSession getSession(boolean create) {
        return (HttpSession)this.extCtx.getSession(create);
    }

    public void setAttribute(String attribute, Object value) {
        this.extCtx.getRequestMap().put(attribute, value);
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
    }

    public String[] getParameterValues(String name) {
        return (String[])this.extCtx.getRequestParameterValuesMap().get(name);
    }

    public String getParameter(String name) {
        return (String)this.extCtx.getRequestParameterMap().get(name);
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public Object getAttribute(String name) {
        return this.extCtx.getRequestMap().get(name);
    }

    public long getDateHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1L;
        }
        return Date.parse(header);
    }

    public String getHeader(String name) {
        return (String)this.extCtx.getRequestHeaderMap().get(name);
    }

    public Enumeration getHeaders(String name) {
        String[] headers = (String[])this.extCtx.getRequestHeaderValuesMap().get(name);
        if (headers == null) {
            headers = new String[]{};
        }
        return Collections.enumeration(Arrays.asList(headers));
    }

    public String getRealPath(String string) {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String name) {
        return this.extCtx.isUserInRole(name);
    }

    public void removeAttribute(String name) {
        this.extCtx.getRequestMap().remove(name);
    }

    public int getLocalPort() {
        if (!this.isServlet14OrGreater) {
            throw new UnsupportedOperationException();
        }
        return this.localPort;
    }

    public int getRemotePort() {
        if (!this.isServlet14OrGreater) {
            throw new UnsupportedOperationException();
        }
        return this.remotePort;
    }

    public String getLocalName() {
        if (!this.isServlet14OrGreater) {
            throw new UnsupportedOperationException();
        }
        return this.localName;
    }

    public String getLocalAddr() {
        if (!this.isServlet14OrGreater) {
            throw new UnsupportedOperationException();
        }
        return this.localAddr;
    }
}

